/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosResultEncoding;
import org.n52.shetland.ogc.sos.SosResultStructure;
import org.n52.shetland.ogc.sos.response.GetResultTemplateResponse;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.shetland.ogc.swe.encoding.SweTextEncoding;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NoDecoderForKeyException;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.json.AbstractSosResponseEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetResultTemplateResponseEncoder
extends AbstractSosResponseEncoder<GetResultTemplateResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(GetResultTemplateResponseEncoder.class);
    private DecoderRepository decoderRepository;

    public GetResultTemplateResponseEncoder() {
        super(GetResultTemplateResponse.class, (Enum)Sos2Constants.Operations.GetResultTemplate);
    }

    @Inject
    public void setDecoderRepository(DecoderRepository decoderRepository) {
        this.decoderRepository = decoderRepository;
    }

    protected void encodeResponse(ObjectNode json, GetResultTemplateResponse t) throws EncodingException {
        this.encodeResultEncoding(t, json);
        this.encodeResultStructure(t, json);
    }

    private void encodeResultStructure(GetResultTemplateResponse t, ObjectNode json) throws EncodingException {
        SweAbstractDataComponent structure;
        ObjectNode jrs = json.putObject("resultStructure");
        SosResultStructure rs = t.getResultStructure();
        if (rs.isDecoded()) {
            structure = (SweAbstractDataComponent)t.getResultStructure().get().get();
        } else {
            try {
                XmlNamespaceDecoderKey key = new XmlNamespaceDecoderKey("http://www.opengis.net/swe/2.0", SweAbstractDataComponent.class);
                Decoder decoder = this.decoderRepository.getDecoder((DecoderKey)key, new DecoderKey[0]);
                if (decoder == null) {
                    throw new NoDecoderForKeyException((DecoderKey)key);
                }
                structure = (SweAbstractDataComponent)decoder.decode((Object)XmlObject.Factory.parse((String)((String)rs.getXml().get())));
            }
            catch (XmlException | DecodingException ex) {
                throw new EncodingException(ex);
            }
        }
        if (structure instanceof SweDataRecord) {
            this.encodeSweDataRecord(structure, jrs);
        } else {
            LOG.warn("Unsupported structure: {}", structure == null ? null : structure.getClass());
        }
    }

    private void encodeResultEncoding(GetResultTemplateResponse t, ObjectNode json) throws EncodingException {
        ObjectNode jre = json.putObject("resultEncoding");
        SweAbstractEncoding encoding = null;
        SosResultEncoding re = t.getResultEncoding();
        if (re.isDecoded()) {
            encoding = (SweAbstractEncoding)t.getResultEncoding().get().get();
        } else {
            try {
                XmlNamespaceDecoderKey key = new XmlNamespaceDecoderKey("http://www.opengis.net/swe/2.0", SweAbstractEncoding.class);
                Decoder decoder = this.decoderRepository.getDecoder((DecoderKey)key, new DecoderKey[0]);
                if (decoder == null) {
                    throw new NoDecoderForKeyException((DecoderKey)key);
                }
                encoding = (SweAbstractEncoding)decoder.decode((Object)XmlObject.Factory.parse((String)((String)re.getXml().get())));
            }
            catch (XmlException | DecodingException ex) {
                throw new EncodingException(ex);
            }
        }
        if (encoding instanceof SweTextEncoding) {
            this.encodeSweTextEncoding(encoding, jre);
        } else {
            LOG.warn("Unsupported encoding: {}", encoding == null ? null : encoding.getClass());
        }
    }

    private void encodeSweTextEncoding(SweAbstractEncoding encoding, ObjectNode node) {
        String ds;
        String bs;
        SweTextEncoding sweTextEncoding = (SweTextEncoding)encoding;
        String ts = sweTextEncoding.getTokenSeparator();
        if (ts != null && !ts.isEmpty()) {
            node.put("tokenSeparator", ts);
        }
        if ((bs = sweTextEncoding.getBlockSeparator()) != null && !bs.isEmpty()) {
            node.put("blockSeparator", bs);
        }
        if ((ds = sweTextEncoding.getDecimalSeparator()) != null && !ds.isEmpty()) {
            node.put("decimalSeparator", ds);
        }
    }

    private void encodeSweDataRecord(SweAbstractDataComponent structure, ObjectNode node) throws EncodingException {
        SweDataRecord sweDataRecord = (SweDataRecord)structure;
        ArrayNode fields = node.putArray("fields");
        for (SweField field : sweDataRecord.getFields()) {
            fields.add(this.encodeObjectToJson(field));
        }
    }
}

