/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.Json;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.OmObservationConstellation;
import org.n52.shetland.ogc.om.TimeValuePair;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.ComplexValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.CvDiscretePointCoverage;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.HrefAttributeValue;
import org.n52.shetland.ogc.om.values.MultiPointCoverage;
import org.n52.shetland.ogc.om.values.NilTemplateValue;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.om.values.QuantityRangeValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.RectifiedGridCoverage;
import org.n52.shetland.ogc.om.values.ReferenceValue;
import org.n52.shetland.ogc.om.values.SweDataArrayValue;
import org.n52.shetland.ogc.om.values.TLVTValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.TimeRangeValue;
import org.n52.shetland.ogc.om.values.UnknownValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.om.values.XmlValue;
import org.n52.shetland.ogc.om.values.visitor.ValueVisitor;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweAbstractDataRecord;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.util.OMHelper;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.encode.json.JSONEncoder;

public class ObservationEncoder
extends JSONEncoder<OmObservation> {
    public ObservationEncoder() {
        super(OmObservation.class, new EncoderKey[0]);
    }

    public JsonNode encodeJSON(OmObservation o) throws EncodingException {
        ObjectNode json = this.nodeFactory().objectNode();
        this.encodeObservationType(o, json);
        this.encodeIdentifier(o, json);
        this.encodeProcedure(o, json);
        this.encodeParameter(o, json);
        this.encodeObservableProperty(o, json);
        this.encodeFeatureOfInterest(o, json);
        this.encodePhenomenonTime(o, json);
        this.encodeResultTime(o, json);
        this.encodeValidTime(o, json);
        this.encodeResult(o, json);
        return json;
    }

    private void encodeIdentifier(OmObservation o, ObjectNode json) {
        if (o.isSetIdentifier()) {
            json.set("identifier", this.encodeCodeWithAuthority(o.getIdentifierCodeWithAuthority()));
        }
    }

    private void encodeProcedure(OmObservation o, ObjectNode json) {
        json.put("procedure", o.getObservationConstellation().getProcedure().getIdentifier());
    }

    private void encodeParameter(OmObservation o, ObjectNode json) throws EncodingException {
        if (o.isSetParameter()) {
            if (o.getParameter().size() == 1) {
                json.set("parameter", this.encodeNamedValue((NamedValue)o.getParameter().iterator().next()));
            } else {
                ArrayNode parameters = json.putArray("parameter");
                for (NamedValue namedValue : o.getParameter()) {
                    parameters.add(this.encodeNamedValue(namedValue));
                }
            }
        }
    }

    private JsonNode encodeNamedValue(NamedValue<?> namedValue) throws EncodingException {
        ObjectNode namedValueObject = this.nodeFactory().objectNode();
        namedValueObject.put("name", namedValue.getName().getHref());
        namedValueObject.set("value", this.encodeValue(namedValue.getValue()));
        ObjectNode parameterObject = this.nodeFactory().objectNode();
        parameterObject.set("NamedValue", (JsonNode)namedValueObject);
        return parameterObject;
    }

    private void encodeObservableProperty(OmObservation o, ObjectNode json) {
        json.put("observableProperty", o.getObservationConstellation().getObservableProperty().getIdentifier());
    }

    private void encodeObservationType(OmObservation o, ObjectNode json) throws EncodingException {
        json.put("type", this.getObservationType(o));
    }

    private void encodeFeatureOfInterest(OmObservation o, ObjectNode json) throws EncodingException {
        OmObservationConstellation oc = o.getObservationConstellation();
        json.set("featureOfInterest", this.encodeObjectToJson(oc.getFeatureOfInterest()));
    }

    private void encodeResultTime(OmObservation o, ObjectNode json) throws EncodingException {
        if (o.isSetResultTime()) {
            json.set("resultTime", this.encodeObjectToJson(o.getResultTime()));
        }
    }

    private void encodeValidTime(OmObservation o, ObjectNode json) throws EncodingException {
        if (o.isSetValidTime()) {
            json.set("validTime", this.encodeObjectToJson(o.getValidTime()));
        }
    }

    private void encodePhenomenonTime(OmObservation o, ObjectNode json) throws EncodingException {
        json.set("phenomenonTime", this.encodeObjectToJson(o.getPhenomenonTime()));
    }

    private void encodeResult(OmObservation o, ObjectNode json) throws EncodingException {
        json.set("result", this.encodeResult(o));
    }

    private JsonNode encodeResult(OmObservation o) throws EncodingException {
        Value value = o.getValue().getValue();
        if (value instanceof TVPValue) {
            return this.encodeTVPValue(o);
        }
        return this.encodeValue(value);
    }

    private JsonNode encodeValue(Value<?> value) throws EncodingException {
        return (JsonNode)value.accept((ValueVisitor)new ValueVisitor<JsonNode, EncodingException>(){

            public JsonNode visit(BooleanValue value) throws EncodingException {
                return ObservationEncoder.this.encodeBooleanValue((Value)value);
            }

            public JsonNode visit(CategoryValue value) throws EncodingException {
                return ObservationEncoder.this.encodeCategoryValue((Value)value);
            }

            public JsonNode visit(ComplexValue value) throws EncodingException {
                return ObservationEncoder.this.encodeComplexValue((Value)value);
            }

            public JsonNode visit(CountValue value) throws EncodingException {
                return ObservationEncoder.this.encodeCountValue((Value)value);
            }

            public JsonNode visit(GeometryValue value) throws EncodingException {
                return ObservationEncoder.this.encodeGeometryValue((Value)value);
            }

            public JsonNode visit(HrefAttributeValue value) {
                return ObservationEncoder.this.encodeHrefAttributeValue(value);
            }

            public JsonNode visit(NilTemplateValue value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(QuantityValue value) throws EncodingException {
                return ObservationEncoder.this.encodeQualityValue((Value)value);
            }

            public JsonNode visit(ReferenceValue value) throws EncodingException {
                return ObservationEncoder.this.encodeReferenceValue(value);
            }

            public JsonNode visit(SweDataArrayValue value) throws EncodingException {
                return ObservationEncoder.this.encodeSweDataArrayValue((Value)value);
            }

            public JsonNode visit(TVPValue value) throws EncodingException {
                return ObservationEncoder.this.encodeTVPValue(value);
            }

            public JsonNode visit(TextValue value) throws EncodingException {
                return ObservationEncoder.this.encodeTextValue((Value)value);
            }

            public JsonNode visit(UnknownValue value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(XmlValue<?> value) throws EncodingException {
                return ObservationEncoder.this.encodeXmlValue(value);
            }

            public JsonNode visit(TLVTValue value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(CvDiscretePointCoverage value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(MultiPointCoverage value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(RectifiedGridCoverage value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(ProfileValue value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(TimeRangeValue value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }

            public JsonNode visit(QuantityRangeValue value) throws EncodingException {
                throw new UnsupportedEncoderInputException((Encoder)ObservationEncoder.this, (Object)value);
            }
        });
    }

    private JsonNode encodeReferenceValue(ReferenceValue value) {
        ReferenceType ref = value.getValue();
        ObjectNode node = this.nodeFactory().objectNode();
        node.put("href", ref.getHref());
        if (ref.isSetRole()) {
            node.put("role", ref.getRole());
        }
        if (ref.isSetTitle()) {
            node.put("title", ref.getTitle());
        }
        return node;
    }

    private JsonNode encodeHrefAttributeValue(HrefAttributeValue value) {
        ObjectNode node = this.nodeFactory().objectNode();
        node.put("href", value.getValue().getHref());
        return node;
    }

    private JsonNode encodeTVPValue(TVPValue value) throws EncodingException {
        ArrayNode arrayNode = this.nodeFactory().arrayNode();
        for (TimeValuePair tvp : value.getValue()) {
            ObjectNode node = this.nodeFactory().objectNode();
            node.set("time", this.encodeObjectToJson(tvp.getTime()));
            node.set("value", this.encodeValue((Value<?>)value));
            arrayNode.add((JsonNode)node);
        }
        return arrayNode;
    }

    private JsonNode encodeTVPValue(OmObservation o) throws EncodingException {
        TVPValue tvpValue = (TVPValue)o.getValue().getValue();
        ObjectNode result = this.nodeFactory().objectNode();
        List values = tvpValue.getValue();
        if (values != null && !values.isEmpty()) {
            String obsProp = o.getObservationConstellation().getObservableProperty().getIdentifier();
            SweTime timeDef = new SweTime();
            timeDef.setDefinition("http://www.opengis.net/def/property/OGC/0/PhenomenonTime");
            timeDef.setUom("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian");
            SweField timeField = new SweField("phenomenonTime", (SweAbstractDataComponent)timeDef);
            SweField valueField = this.getFieldForValue(obsProp, ((TimeValuePair)values.get(0)).getValue());
            result.putArray("fields").add(this.encodeObjectToJson(timeField)).add(this.encodeObjectToJson(valueField));
            ArrayNode jvalues = result.putArray("values");
            for (TimeValuePair tvp : values) {
                if (tvp == null || tvp.getValue() == null || !tvp.getValue().isSetValue()) continue;
                jvalues.addArray().add(this.encodeObjectToJson(tvp.getTime())).add(this.getTokenForValue(tvp.getValue()));
            }
        }
        return result;
    }

    private JsonNode encodeQualityValue(Value<?> value) {
        QuantityValue quantityValue = (QuantityValue)value;
        ObjectNode node = this.nodeFactory().objectNode();
        node.put("uom", quantityValue.getUnit());
        node.put("value", quantityValue.getValue());
        return node;
    }

    private JsonNode encodeCountValue(Value<?> value) {
        CountValue countValue = (CountValue)value;
        return this.nodeFactory().numberNode(countValue.getValue());
    }

    private JsonNode encodeTextValue(Value<?> value) {
        TextValue textValue = (TextValue)value;
        return this.nodeFactory().textNode(textValue.getValue());
    }

    private JsonNode encodeBooleanValue(Value<?> value) {
        BooleanValue booleanValue = (BooleanValue)value;
        return this.nodeFactory().booleanNode(booleanValue.getValue().booleanValue());
    }

    private JsonNode encodeCategoryValue(Value<?> value) {
        CategoryValue categoryValue = (CategoryValue)value;
        ObjectNode node = this.nodeFactory().objectNode();
        node.put("codespace", categoryValue.getUnit());
        node.put("value", categoryValue.getValue());
        return node;
    }

    private JsonNode encodeGeometryValue(Value<?> value) throws EncodingException {
        GeometryValue geometryValue = (GeometryValue)value;
        return this.encodeObjectToJson(geometryValue.getValue());
    }

    private JsonNode encodeComplexValue(Value<?> value) throws EncodingException {
        ArrayNode result = this.nodeFactory().arrayNode();
        ComplexValue complexValue = (ComplexValue)value;
        SweAbstractDataRecord sweDataRecord = complexValue.getValue();
        for (SweField field : sweDataRecord.getFields()) {
            result.add(this.encodeObjectToJson(field));
        }
        return result;
    }

    private JsonNode encodeSweDataArrayValue(Value<?> value) throws EncodingException {
        SweDataArrayValue sweDataArrayValue = (SweDataArrayValue)value;
        ObjectNode result = this.nodeFactory().objectNode();
        ArrayNode jfields = result.putArray("fields");
        ArrayNode jvalues = result.putArray("values");
        List fields = ((SweDataRecord)sweDataArrayValue.getValue().getElementType()).getFields();
        List values = sweDataArrayValue.getValue().getValues();
        TokenConverter[] conv = new TokenConverter[fields.size()];
        int i = 0;
        for (SweField field : fields) {
            try {
                conv[i++] = TokenConverter.forField(field);
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedEncoderInputException((Encoder)this, (Object)field);
            }
            jfields.add(this.encodeObjectToJson(field));
        }
        for (List block : values) {
            ArrayNode jblock = jvalues.addArray();
            i = 0;
            for (String token : block) {
                jblock.add(conv[i++].convert(token));
            }
        }
        return result;
    }

    private TextNode encodeXmlValue(XmlValue<?> value) {
        if (value.getValue() instanceof XmlObject) {
            return this.nodeFactory().textNode(((XmlObject)value.getValue()).xmlText());
        }
        return null;
    }

    private String getObservationType(OmObservation o) throws EncodingException {
        if (o.getObservationConstellation().isSetObservationType()) {
            return o.getObservationConstellation().getObservationType();
        }
        return OMHelper.getObservationTypeFor((Value)o.getValue().getValue());
    }

    private SweField getFieldForValue(String phenomenon, Value<?> value) throws EncodingException {
        SweBoolean def;
        if (value instanceof BooleanValue) {
            def = new SweBoolean();
        } else if (value instanceof CategoryValue) {
            SweCategory sweCategory = new SweCategory();
            CategoryValue categoryValue = (CategoryValue)value;
            sweCategory.setCodeSpace(categoryValue.getUnit());
            def = sweCategory;
        } else if (value instanceof CountValue) {
            def = new SweCount();
        } else if (value instanceof QuantityValue) {
            SweQuantity sweQuantity = new SweQuantity();
            QuantityValue quantityValue = (QuantityValue)value;
            sweQuantity.setUom(quantityValue.getUnit());
            def = sweQuantity;
        } else if (value instanceof TextValue) {
            def = new SweText();
        } else if (value instanceof NilTemplateValue) {
            def = new SweText();
        } else if (value instanceof BooleanValue) {
            def = new SweBoolean();
        } else if (value instanceof GeometryValue) {
            def = new SweText();
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, value);
        }
        def.setDefinition(phenomenon);
        return new SweField(phenomenon, (SweAbstractDataComponent)def);
    }

    private JsonNode getTokenForValue(Value<?> value) throws EncodingException {
        if (value instanceof QuantityValue) {
            QuantityValue quantityValue = (QuantityValue)value;
            return this.nodeFactory().numberNode(quantityValue.getValue());
        }
        if (value instanceof CountValue) {
            CountValue countValue = (CountValue)value;
            return this.nodeFactory().numberNode(countValue.getValue());
        }
        if (value instanceof TextValue) {
            TextValue textValue = (TextValue)value;
            return this.nodeFactory().textNode(textValue.getValue());
        }
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return this.nodeFactory().booleanNode(booleanValue.getValue().booleanValue());
        }
        if (value instanceof CategoryValue) {
            CategoryValue categoryValue = (CategoryValue)value;
            return this.nodeFactory().textNode(categoryValue.getValue());
        }
        if (value instanceof GeometryValue) {
            GeometryValue geometryValue = (GeometryValue)value;
            return this.encodeObjectToJson(geometryValue);
        }
        if (value instanceof NilTemplateValue) {
            return this.nodeFactory().nullNode();
        }
        throw new UnsupportedEncoderInputException((Encoder)this, value);
    }

    private static abstract class TokenConverter {
        private static final TokenConverter TEXT_CONVERTER = new TextConverter();
        private static final TokenConverter COUNT_CONVERTER = new CountConverter();
        private static final TokenConverter QUANTITY_CONVERTER = new QuantityConverter();
        private static final TokenConverter BOOLEAN_CONVERTER = new BooleanConverter();
        private static final TokenConverter OBSERVABLE_PROPERTY_CONVERTER = TEXT_CONVERTER;
        private static final TokenConverter CATEGORY_CONVERTER = TEXT_CONVERTER;
        private static final TokenConverter TIME_CONVERTER = TEXT_CONVERTER;
        private static final TokenConverter TIME_RANGE_CONVERTER = new RangeTokenConverter(TIME_CONVERTER);
        private static final TokenConverter QUANTITY_RANGE_CONVERTER = new RangeTokenConverter(QUANTITY_CONVERTER);
        private static final TokenConverter COUNT_RANGE_CONVERTER = new RangeTokenConverter(COUNT_CONVERTER);

        private TokenConverter() {
        }

        JsonNodeFactory nodeFactory() {
            return Json.nodeFactory();
        }

        abstract JsonNode convert(String var1);

        static TokenConverter forField(SweField field) {
            switch (field.getElement().getDataComponentType()) {
                case Count: {
                    return COUNT_CONVERTER;
                }
                case Boolean: {
                    return BOOLEAN_CONVERTER;
                }
                case CountRange: {
                    return COUNT_RANGE_CONVERTER;
                }
                case ObservableProperty: {
                    return OBSERVABLE_PROPERTY_CONVERTER;
                }
                case Text: {
                    return TEXT_CONVERTER;
                }
                case Quantity: {
                    return QUANTITY_CONVERTER;
                }
                case QuantityRange: {
                    return QUANTITY_RANGE_CONVERTER;
                }
                case Time: {
                    return TIME_CONVERTER;
                }
                case TimeRange: {
                    return TIME_RANGE_CONVERTER;
                }
                case Category: {
                    return CATEGORY_CONVERTER;
                }
            }
            throw new IllegalArgumentException("Unknown field type");
        }

        private static class CountConverter
        extends TokenConverter {
            private CountConverter() {
            }

            @Override
            JsonNode convert(String s) {
                return this.nodeFactory().numberNode(Integer.parseInt(s));
            }
        }

        private static class BooleanConverter
        extends TokenConverter {
            private BooleanConverter() {
            }

            @Override
            JsonNode convert(String s) {
                return this.nodeFactory().booleanNode(Boolean.parseBoolean(s));
            }
        }

        private static class QuantityConverter
        extends TokenConverter {
            private QuantityConverter() {
            }

            @Override
            JsonNode convert(String s) {
                return this.nodeFactory().numberNode(new BigDecimal(s));
            }
        }

        private static class TextConverter
        extends TokenConverter {
            private TextConverter() {
            }

            @Override
            JsonNode convert(String s) {
                return this.nodeFactory().textNode(s);
            }
        }

        private static class RangeTokenConverter
        extends TokenConverter {
            private final TokenConverter conv;

            RangeTokenConverter(TokenConverter conv) {
                this.conv = conv;
            }

            @Override
            JsonNode convert(String s) {
                String[] split = s.split("/");
                return this.nodeFactory().arrayNode().add(this.conv.convert(split[0])).add(this.conv.convert(split[1]));
            }
        }
    }
}

