/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.n52.janmayen.Json;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.ExceptionEncoderKey;
import org.n52.svalbard.encode.json.JSONEncoder;
import org.n52.svalbard.encode.json.JSONEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwsExceptionReportEncoder
extends JSONEncoder<OwsExceptionReport> {
    public static final char LF = '\n';
    public static final String LINE = "line";
    public static final String CLASS = "class";
    public static final String FILE = "file";
    public static final String METHOD = "method";
    public static final String STACK_TRACE = "stackTrace";
    private static final Logger log = LoggerFactory.getLogger(OwsExceptionReportEncoder.class);

    public OwsExceptionReportEncoder() {
        super(OwsExceptionReport.class, new EncoderKey[]{new ExceptionEncoderKey(MediaTypes.APPLICATION_JSON)});
    }

    public JsonNode encodeJSON(OwsExceptionReport t) throws JSONEncodingException {
        ObjectNode exceptionReport = Json.nodeFactory().objectNode();
        exceptionReport.put("version", t.getVersion());
        ArrayNode exceptions = exceptionReport.putArray("exceptions");
        for (CodedException ce : t.getExceptions()) {
            String message;
            ObjectNode exception = exceptions.addObject();
            exception.put("code", ce.getCode() != null ? ce.getCode().toString() : OwsExceptionCode.NoApplicableCode.toString());
            if (ce.getLocator() != null && !ce.getLocator().isEmpty()) {
                exception.put("locator", ce.getLocator());
            }
            if ((message = this.getExceptionText(ce)) != null && !message.isEmpty()) {
                exception.put("text", message);
            }
            if (!log.isDebugEnabled()) continue;
            exception.set(STACK_TRACE, this.encodeStackTrace((Throwable)ce));
        }
        return exceptionReport;
    }

    protected String getExceptionText(CodedException ce) {
        StringBuilder exceptionText = new StringBuilder();
        if (ce.getMessage() != null) {
            exceptionText.append(ce.getMessage());
        }
        if (ce.getCause() != null) {
            if (exceptionText.length() > 0) {
                exceptionText.append('\n');
            }
            exceptionText.append("[EXCEPTION]: ").append('\n');
            String localizedMessage = ce.getCause().getLocalizedMessage();
            String message = ce.getCause().getMessage();
            if (localizedMessage != null && message != null) {
                if (!message.equals(localizedMessage)) {
                    exceptionText.append(message).append('\n');
                }
                exceptionText.append(localizedMessage).append('\n');
            } else {
                exceptionText.append(localizedMessage).append('\n');
                exceptionText.append(message).append('\n');
            }
        }
        return exceptionText.toString();
    }

    private JsonNode encodeStackTrace(Throwable t) {
        ArrayNode json = this.nodeFactory().arrayNode();
        for (StackTraceElement e : t.getStackTrace()) {
            json.add(String.format("%s.%s(:%d)", e.getClassName(), e.getMethodName(), e.getLineNumber()));
        }
        return json;
    }
}

