/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.inspire.ad.AddressRepresentation;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.read.AddressAreaReader;
import org.n52.svalbard.read.AdminUnitReader;
import org.n52.svalbard.read.LocatorNameReader;
import org.n52.svalbard.read.NillableReferenceReader;
import org.n52.svalbard.read.NillableStringReader;
import org.n52.svalbard.read.PostNameReader;
import org.n52.svalbard.read.ThoroughfareReader;
import org.n52.svalbard.read.XmlReader;

public class AddressRepresentationReader
extends XmlReader<AddressRepresentation> {
    private AddressRepresentation address;

    @Override
    protected void begin() throws XMLStreamException, DecodingException {
        this.address = new AddressRepresentation();
    }

    @Override
    protected void read(QName name) throws XMLStreamException, DecodingException {
        if (name.equals(AqdConstants.QN_AD_ADMIN_UNIT)) {
            this.address.addAdminUnit(this.delegate(new AdminUnitReader()));
        } else if (name.equals(AqdConstants.QN_AD_LOCATOR_DESIGNATOR)) {
            this.address.addLocatorDesignator(this.chars());
        } else if (name.equals(AqdConstants.QN_AD_LOCATOR_NAME)) {
            this.address.addLocatorName(this.delegate(new LocatorNameReader()));
        } else if (name.equals(AqdConstants.QN_AD_ADDRESS_AREA)) {
            this.address.addAddressArea(this.delegate(new AddressAreaReader()));
        } else if (name.equals(AqdConstants.QN_AD_POST_NAME)) {
            this.address.addPostName(this.delegate(new PostNameReader()));
        } else if (name.equals(AqdConstants.QN_AD_POST_CODE)) {
            this.address.setPostCode(this.delegate(new NillableStringReader()));
        } else if (name.equals(AqdConstants.QN_AD_THOROUGHFARE)) {
            this.address.addThoroughfare(this.delegate(new ThoroughfareReader()));
        } else if (name.equals(AqdConstants.QN_AD_ADDRESS_FEATURE)) {
            this.address.setAddressFeature(this.delegate(new NillableReferenceReader()));
        } else {
            this.ignore();
        }
    }

    @Override
    protected AddressRepresentation finish() throws DecodingException {
        return this.address;
    }
}

