/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.read.XmlReader;

public class CodeTypeReader
extends XmlReader<CodeType> {
    private CodeType codeType;

    @Override
    protected void begin() throws XMLStreamException, DecodingException {
        String codeSpace = (String)this.attr("codeSpace").orNull();
        try {
            this.codeType = !Strings.isNullOrEmpty((String)codeSpace) ? new CodeType(this.chars(), new URI(codeSpace)) : new CodeType(this.chars());
        }
        catch (URISyntaxException e) {
            throw new DecodingException((Throwable)e, "Error while creating URI from '{}'", codeSpace, new Object[0]);
        }
    }

    @Override
    protected CodeType finish() {
        return this.codeType;
    }
}

