/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.inspire.base2.Contact;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.read.AddressReader;
import org.n52.svalbard.read.NillableFreeTextReader;
import org.n52.svalbard.read.NillableStringReader;
import org.n52.svalbard.read.XmlReader;

public class ContactReader
extends XmlReader<Contact> {
    private Contact contact;

    @Override
    protected void begin() throws XMLStreamException, DecodingException {
        this.contact = new Contact();
    }

    @Override
    protected void read(QName name) throws XMLStreamException, DecodingException {
        if (name.equals(AqdConstants.QN_BASE2_ADDRESS)) {
            this.contact.setAddress(this.delegate(new AddressReader()));
        } else if (name.equals(AqdConstants.QN_BASE2_CONTACT_INSTRUCTIONS)) {
            this.contact.setContactInstructions(this.delegate(new NillableFreeTextReader()));
        } else if (name.equals(AqdConstants.QN_BASE2_ELECTRONIC_MAIL_ADDRESS)) {
            this.contact.setElectronicMailAddress(this.delegate(new NillableStringReader()));
        } else if (name.equals(AqdConstants.QN_BASE2_HOURS_OF_SERVICE)) {
            this.contact.setHoursOfService(this.delegate(new NillableFreeTextReader()));
        } else if (name.equals(AqdConstants.QN_BASE2_WEBSITE)) {
            this.contact.setWebsite(this.delegate(new NillableStringReader()));
        } else if (name.equals(AqdConstants.QN_BASE2_TELEPHONE_FACSIMILE)) {
            this.contact.addTelephoneFacsimile(this.delegate(new NillableStringReader()));
        } else if (name.equals(AqdConstants.QN_BASE2_TELEPHONE_VOICE)) {
            this.contact.addTelephoneVoice(this.delegate(new NillableStringReader()));
        } else {
            this.ignore();
        }
    }

    @Override
    protected Contact finish() throws DecodingException {
        return this.contact;
    }
}

