/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.inspire.GeographicalName;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.read.NillableCodeTypeReader;
import org.n52.svalbard.read.NillableStringReader;
import org.n52.svalbard.read.PronounciationReader;
import org.n52.svalbard.read.SpellingReader;
import org.n52.svalbard.read.XmlReader;

public class GeographicalNameReader
extends XmlReader<GeographicalName> {
    private GeographicalName geographicalName;

    @Override
    protected void begin() {
        this.geographicalName = new GeographicalName();
    }

    @Override
    protected void read(QName name) throws XMLStreamException, DecodingException {
        if (name.equals(AqdConstants.QN_GN_LANGUAGE)) {
            this.geographicalName.setLanguage(this.delegate(new NillableStringReader()));
        } else if (name.equals(AqdConstants.QN_GN_NATIVENESS)) {
            this.geographicalName.setNativeness(this.delegate(new NillableCodeTypeReader()));
        } else if (name.equals(AqdConstants.QN_GN_NAME_STATUS)) {
            this.geographicalName.setNameStatus(this.delegate(new NillableCodeTypeReader()));
        } else if (name.equals(AqdConstants.QN_GN_SOURCE_OF_NAME)) {
            this.geographicalName.setSourceOfName(this.delegate(new NillableStringReader()));
        } else if (name.equals(AqdConstants.QN_GN_PRONUNCIATION)) {
            this.geographicalName.setPronunciation(this.delegate(new PronounciationReader()));
        } else if (name.equals(AqdConstants.QN_GN_SPELLING)) {
            this.geographicalName.addSpelling(this.delegate(new SpellingReader()));
        } else if (name.equals(AqdConstants.QN_GN_GRAMMATICAL_GENDER)) {
            this.geographicalName.setGrammaticalGender(this.delegate(new NillableCodeTypeReader()));
        } else if (name.equals(AqdConstants.QN_GN_GRAMMATICAL_NUMBER)) {
            this.geographicalName.setGrammaticalNumber(this.delegate(new NillableCodeTypeReader()));
        } else {
            this.ignore();
        }
    }

    @Override
    protected GeographicalName finish() {
        return this.geographicalName;
    }
}

