/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.iso.GcoConstants;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.read.XmlReader;

public abstract class NillableReader<T>
extends XmlReader<Nillable<T>> {
    private Nillable<T> nillable;

    protected abstract XmlReader<T> getDelegate();

    protected List<QName> getPossibleNilReasonAttributes() {
        return Arrays.asList(AqdConstants.QN_NIL_REASON, GcoConstants.QN_GCO_NIL_REASON);
    }

    @Override
    protected void begin() throws XMLStreamException, DecodingException {
        Optional<String> attr = this.attr(W3CConstants.QN_XSI_NIL);
        if (attr.isPresent() && ((String)attr.get()).equals("true")) {
            List<QName> attributeNames = this.getPossibleNilReasonAttributes();
            Iterable<Optional<String>> attributes = this.attr(attributeNames);
            Iterable reasons = Optional.presentInstances(attributes);
            this.nillable = Nillable.nil((String)((String)Iterables.getFirst((Iterable)reasons, null)));
        } else {
            this.nillable = Nillable.of(this.delegate(this.getDelegate()));
        }
    }

    @Override
    protected Nillable<T> finish() {
        return this.nillable;
    }
}

