/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import com.google.common.base.Function;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.inspire.Pronunciation;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.read.NillableStringReader;
import org.n52.svalbard.read.XmlReader;

public class PronunciationOfNameReader
extends XmlReader<Pronunciation> {
    private static final Function<String, URI> STRING_TO_URI = new Function<String, URI>(){

        public URI apply(String input) {
            return URI.create(input);
        }
    };
    private Pronunciation pronunciation;

    @Override
    protected void begin() {
        this.pronunciation = new Pronunciation();
    }

    @Override
    protected void read(QName name) throws XMLStreamException, DecodingException {
        if (name.equals(AqdConstants.QN_GN_PRONUNCIATION_SOUND_LINK)) {
            this.pronunciation.setSoundLink(this.delegate(new NillableStringReader()).transform(STRING_TO_URI));
        } else if (name.equals(AqdConstants.QN_GN_PRONUNCIATION_IPA)) {
            this.pronunciation.setIPA(this.delegate(new NillableStringReader()));
        } else {
            this.ignore();
        }
    }

    @Override
    protected Pronunciation finish() {
        return this.pronunciation;
    }
}

