/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.aqd.EReportingChange;
import org.n52.shetland.aqd.EReportingHeader;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.read.InpireIDReader;
import org.n52.svalbard.read.ReferenceableFeatureReader;
import org.n52.svalbard.read.ReportingAuthorityReader;
import org.n52.svalbard.read.ReportingPeriodReader;
import org.n52.svalbard.read.XmlReader;

public class ReportingHeaderReader
extends XmlReader<EReportingHeader> {
    private EReportingHeader header;
    private boolean change;
    private String changeDescription;

    @Override
    protected void begin() {
        this.header = new EReportingHeader();
    }

    @Override
    protected void read(QName name) throws XMLStreamException, DecodingException {
        if (name.equals(AqdConstants.QN_AQD_INSPIRE_ID)) {
            this.header.setInspireID(this.delegate(new InpireIDReader()));
        } else if (name.equals(AqdConstants.QN_AQD_REPORTING_AUTHORITY)) {
            this.header.setReportingAuthority(this.delegate(new ReportingAuthorityReader()));
        } else if (name.equals(AqdConstants.QN_AQD_REPORTING_PERIOD)) {
            this.header.setReportingPeriod(this.delegate(new ReportingPeriodReader()));
        } else if (name.equals(AqdConstants.QN_AQD_CONTENT)) {
            this.header.addContent(this.delegate(new ReferenceableFeatureReader()));
        } else if (name.equals(AqdConstants.QN_AQD_DELETE)) {
            this.header.addDelete(this.delegate(new ReferenceableFeatureReader()));
        } else if (name.equals(AqdConstants.QN_AQD_CHANGE)) {
            this.change = Boolean.valueOf(this.chars());
        } else if (name.equals(AqdConstants.QN_AQD_CHANGE_DESCRIPTION)) {
            this.changeDescription = this.chars();
        } else {
            this.ignore();
        }
    }

    @Override
    protected EReportingHeader finish() throws DecodingException {
        return this.header.setChange(new EReportingChange(this.change, this.changeDescription));
    }
}

