/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.read;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.n52.svalbard.decode.exception.DecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlReader.class);
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private XMLStreamReader reader;
    private QName root;
    private int rootCount;

    public T read(InputStream in) throws XMLStreamException, DecodingException {
        return this.read(this.inputFactory.createXMLStreamReader(in));
    }

    private T read(XmlReader<?> reader) throws XMLStreamException, DecodingException {
        return this.read(reader.reader);
    }

    private T read(XMLStreamReader reader) throws XMLStreamException, DecodingException {
        this.reader = reader;
        this.root = this.toNextBeginTag();
        String cName = this.getClass().getSimpleName();
        this.rootCount = 0;
        if (this.root != null && !this.isEndTag()) {
            QName current;
            LOG.trace("{}: root: <{}:{}>", new Object[]{cName, this.root.getPrefix(), this.root.getLocalPart()});
            this.begin();
            if (this.isEndTag() && this.tagName().equals(this.root)) {
                return this.finish();
            }
            while ((current = this.toNextTag()) != null) {
                if (this.isStartTag()) {
                    LOG.trace("{}: begin: <{}:{}>", new Object[]{cName, current.getPrefix(), current.getLocalPart()});
                    if (current.equals(this.root)) {
                        ++this.rootCount;
                    }
                    this.read(current);
                    continue;
                }
                if (!this.isEndTag()) continue;
                LOG.trace("{}: end: <{}:{}>", new Object[]{cName, current.getPrefix(), current.getLocalPart()});
                if (!current.equals(this.root)) continue;
                if (this.rootCount == 0) break;
                --this.rootCount;
            }
        }
        return this.finish();
    }

    protected void read(QName name) throws XMLStreamException, DecodingException {
        this.ignore();
    }

    protected <T> T delegate(XmlReader<? extends T> reader) throws XMLStreamException, DecodingException {
        return super.read(this);
    }

    private boolean isStartTag() {
        return this.reader.isStartElement();
    }

    private boolean isEndTag() {
        return this.reader.isEndElement();
    }

    private boolean hasNext() throws XMLStreamException {
        return this.reader.hasNext();
    }

    private void next() throws XMLStreamException {
        this.reader.next();
    }

    private QName toNextTag() throws XMLStreamException {
        if (this.hasNext()) {
            this.next();
            return this.toTag();
        }
        return null;
    }

    private QName toNextBeginTag() throws XMLStreamException {
        while (!this.isStartTag() && this.hasNext()) {
            this.toNextTag();
        }
        return this.isStartTag() ? this.tagName() : null;
    }

    private QName toTag() throws XMLStreamException {
        while (!this.isStartTag() && !this.isEndTag() && this.hasNext()) {
            this.next();
        }
        return this.isStartTag() || this.isEndTag() ? this.tagName() : null;
    }

    protected Map<QName, String> attr() {
        int l = this.reader.getAttributeCount();
        HashMap<QName, String> attr = new HashMap<QName, String>(l);
        for (int i = 0; i < l; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            attr.put(this.reader.getAttributeName(i), this.reader.getAttributeValue(i));
        }
        return attr;
    }

    protected Iterable<Optional<String>> attr(Iterable<QName> names) {
        return Iterables.transform(names, this::attr);
    }

    protected Optional<String> attr(QName qn) {
        return Optional.fromNullable((Object)this.attr().get(qn));
    }

    protected Optional<String> attr(String name) {
        return this.attr(new QName(name));
    }

    protected QName tagName() {
        return this.reader.getName();
    }

    protected String chars() throws XMLStreamException {
        return this.reader.getElementText();
    }

    protected void begin() throws XMLStreamException, DecodingException {
    }

    protected abstract T finish() throws DecodingException;

    protected void ignore() {
        QName name = this.reader.getName();
        String cName = this.getClass().getSimpleName();
        LOG.warn("{}: ignoring element {}:{}", new Object[]{cName, name.getPrefix(), name.getLocalPart()});
    }
}

