/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.gml.time.TimePosition;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityConstants;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.XmlStreamWriter;

public abstract class AbstractGetDataAvailabilityStreamWriter
extends XmlStreamWriter<List<GetDataAvailabilityResponse.DataAvailability>> {
    protected static final String TIME_PERIOD_PREFIX = "tp_";
    protected static final String DATA_AVAILABILITY_PREFIX = "dam_";
    protected static final String RESULT_TIME = "resultTime";
    protected static final String AN_NAME = "name";
    protected static final String AN_DEFINITION = "definition";
    protected final Map<TimePeriod, String> times = new HashMap<TimePeriod, String>();
    protected int dataAvailabilityCount = 1;
    protected int timePeriodCount = 1;
    protected int resultTimeCount = 1;

    public AbstractGetDataAvailabilityStreamWriter(EncodingContext context, OutputStream outputStream, List<GetDataAvailabilityResponse.DataAvailability> element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    public void write() throws XMLStreamException, EncodingException {
        this.start();
        this.writeGetDataAvailabilityResponse();
        this.end();
        this.finish();
    }

    protected abstract void writeGetDataAvailabilityResponse() throws XMLStreamException, EncodingException;

    protected abstract void wirteDataAvailabilityMember(GetDataAvailabilityResponse.DataAvailability var1) throws XMLStreamException, EncodingException;

    protected void writePhenomenonTime(GetDataAvailabilityResponse.DataAvailability da, QName element) throws DateTimeFormatException, XMLStreamException {
        if (this.times.containsKey(da.getPhenomenonTime())) {
            this.empty(element);
            this.attr(GetDataAvailabilityConstants.XLINK_HREF, "#" + this.times.get(da.getPhenomenonTime()));
        } else {
            this.start(element);
            da.getPhenomenonTime().setGmlId(TIME_PERIOD_PREFIX + this.timePeriodCount++);
            this.times.put(da.getPhenomenonTime(), da.getPhenomenonTime().getGmlId());
            this.writeTimePeriod(da.getPhenomenonTime());
            this.end(element);
        }
    }

    protected void writeFeatureOfInterest(GetDataAvailabilityResponse.DataAvailability da, QName element) throws XMLStreamException {
        this.empty(element);
        this.attr(GetDataAvailabilityConstants.XLINK_HREF, da.getFeatureOfInterest().getHref());
        if (da.getFeatureOfInterest().isSetTitle()) {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, da.getFeatureOfInterest().getTitle());
        } else {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, da.getFeatureOfInterest().getTitleOrFromHref());
        }
    }

    protected void writeProcedure(GetDataAvailabilityResponse.DataAvailability da, QName element) throws XMLStreamException {
        this.empty(element);
        this.attr(GetDataAvailabilityConstants.XLINK_HREF, da.getProcedure().getHref());
        if (da.getProcedure().isSetTitle()) {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, da.getProcedure().getTitle());
        } else {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, da.getProcedure().getTitleOrFromHref());
        }
    }

    protected void writeObservedProperty(GetDataAvailabilityResponse.DataAvailability da, QName element) throws XMLStreamException {
        this.empty(element);
        this.attr(GetDataAvailabilityConstants.XLINK_HREF, da.getObservedProperty().getHref());
        if (da.getObservedProperty().isSetTitle()) {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, da.getObservedProperty().getTitle());
        } else {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, da.getObservedProperty().getTitleOrFromHref());
        }
    }

    protected void writeTimePeriod(TimePeriod tp) throws XMLStreamException, DateTimeFormatException {
        this.start(GmlConstants.QN_TIME_PERIOD_32);
        this.attr(GmlConstants.QN_ID_32, tp.getGmlId());
        this.writeTimePosition(GmlConstants.QN_BEGIN_POSITION_32, tp.getStartTimePosition());
        this.writeTimePosition(GmlConstants.QN_END_POSITION_32, tp.getEndTimePosition());
        this.end(GmlConstants.QN_TIME_PERIOD_32);
    }

    protected void writeTimePosition(QName name, TimePosition position) throws XMLStreamException {
        if (position.isSetIndeterminateValue()) {
            this.empty(name);
            this.attr("indeterminatePosition", position.getIndeterminateValue().getValue());
        }
        if (position.isSetTime()) {
            this.start(name);
            this.writeTimeString(position.getTime(), position.getTimeFormat());
            this.end(name);
        }
    }

    protected void writeTimeString(DateTime time, Time.TimeFormat format) throws XMLStreamException, DateTimeFormatException {
        this.chars(DateTimeHelper.formatDateTime2String((DateTime)time, (Time.TimeFormat)format));
    }

    protected void writeCount(long count, QName element) throws XMLStreamException {
        this.start(element);
        this.chars(Long.toString(count));
        this.end(element);
    }

    protected void writeResultTimes(List<TimeInstant> resultTimes, QName element) throws XMLStreamException {
        this.start(element);
        this.start(SweConstants.QN_DATA_RECORD_SWE_200);
        this.attr(AN_DEFINITION, RESULT_TIME);
        for (TimeInstant resultTime : resultTimes) {
            this.start(SweConstants.QN_FIELD_200);
            this.attr(AN_NAME, RESULT_TIME + this.resultTimeCount++);
            this.writeTime(resultTime);
            this.end(SweConstants.QN_FIELD_200);
        }
        this.end(SweConstants.QN_DATA_RECORD_SWE_200);
        this.end(element);
    }

    protected void writeTime(TimeInstant ti) throws XMLStreamException, DateTimeFormatException {
        this.start(SweConstants.QN_TIME_SWE_200);
        this.writeSweValue(ti);
        this.writeSweUOM("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian");
        this.end(SweConstants.QN_TIME_SWE_200);
    }

    private void writeSweUOM(String uom) throws XMLStreamException {
        this.start(SweConstants.QN_UOM_SWE_200);
        this.attr(W3CConstants.QN_XLINK_HREF, uom);
        this.end(SweConstants.QN_UOM_SWE_200);
    }

    protected void writeSweValue(TimeInstant ti) throws XMLStreamException, DateTimeFormatException {
        this.start(SweConstants.QN_VALUE_SWE_200);
        this.writeTimeString(ti.getValue(), ti.getTimeFormat());
        this.end(SweConstants.QN_VALUE_SWE_200);
    }

    protected void writeSweValue(String value) throws XMLStreamException {
        this.start(SweConstants.QN_VALUE_SWE_200);
        this.chars(value);
        this.end(SweConstants.QN_VALUE_SWE_200);
    }

    protected void writeMetadata(Map<String, NamedValue<?>> map, QName element) throws XMLStreamException, EncodingException {
        for (Map.Entry<String, NamedValue<?>> entry : map.entrySet()) {
            Object o = this.getEncoder("http://www.opengis.net/om/2.0", entry.getValue()).encode(entry.getValue(), EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT));
            if (o == null || !(o instanceof XmlObject)) continue;
            this.start(GetDataAvailabilityConstants.GDA_EXTENSION);
            this.attr(AN_NAME, entry.getKey());
            this.writeXmlObject((XmlObject)o);
            this.end(GetDataAvailabilityConstants.GDA_EXTENSION);
        }
    }
}

