/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.base.Strings;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import net.opengis.om.x20.OMObservationType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.joda.time.DateTime;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractMetaData;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.AbstractObservationValue;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityConstants;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.JavaHelper;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.GmlHelper;
import org.n52.svalbard.write.XmlStreamWriter;

public abstract class AbstractOmV20XmlStreamWriter
extends XmlStreamWriter<OmObservation> {
    public AbstractOmV20XmlStreamWriter(EncodingContext context, OutputStream outputStream, OmObservation element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    protected abstract void writeAddtitionalNamespaces() throws XMLStreamException;

    @Override
    public void write() throws XMLStreamException, EncodingException {
        this.start();
        this.writeObservation((OmObservation)this.getElement());
        this.end();
        this.finish();
    }

    protected void writeObservation(OmObservation observation) throws XMLStreamException, EncodingException {
        Time phenomenonTime;
        this.start(this.getDocumentName());
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.namespace("om", "http://www.opengis.net/om/2.0");
        this.namespace("gml", "http://www.opengis.net/gml/3.2");
        this.writeAddtitionalNamespaces();
        String observationID = this.addGmlId(observation);
        this.checkAndWriteIdentifier();
        this.checkAndWriteName();
        this.checkAndWriteDescription();
        if (observation.getObservationConstellation().isSetObservationType()) {
            this.writeObservationType(observation.getObservationConstellation().getObservationType());
        }
        if (observation.isSetMetaDataProperty()) {
            this.writeMetaDataProperty(observation.getMetaDataProperty());
        }
        if ((phenomenonTime = observation.getPhenomenonTime()).getGmlId() == null) {
            phenomenonTime.setGmlId("phenomenonTime_" + observationID);
        }
        this.writePhenomenonTime(phenomenonTime);
        this.writeResultTime();
        if (observation.isSetValidTime()) {
            this.writeValidTime(observation.getValidTime());
        }
        this.writeProcedure();
        if (observation.isSetParameter()) {
            this.writeParameter();
        }
        this.writeObservableProperty();
        this.writeFeatureOfIntererst();
        this.writeResult();
        this.end(this.getDocumentName());
    }

    protected void checkAndWriteIdentifier() throws XMLStreamException, EncodingException {
        if (((OmObservation)this.getElement()).isSetIdentifier()) {
            this.writeIdentifier(((OmObservation)this.getElement()).getIdentifierCodeWithAuthority());
        }
    }

    protected void checkAndWriteName() throws XMLStreamException, EncodingException {
        if (((OmObservation)this.getElement()).isSetName()) {
            for (CodeType name : ((OmObservation)this.getElement()).getName()) {
                this.writeName(name);
            }
        }
    }

    protected void checkAndWriteDescription() throws XMLStreamException {
        if (((OmObservation)this.getElement()).isSetDescription()) {
            this.writeDescription(((OmObservation)this.getElement()).getDescription());
        }
    }

    protected void writeIdentifier(CodeWithAuthority identifier) throws EncodingException, XMLStreamException {
        Encoder encoder = this.getEncoder("http://www.opengis.net/gml/3.2", identifier);
        this.writeXmlObject((XmlObject)encoder.encode((Object)identifier), GmlConstants.QN_IDENTIFIER_32);
    }

    protected void writeName(CodeType name) throws XMLStreamException, EncodingException {
        Encoder encoder = this.getEncoder("http://www.opengis.net/gml/3.2", name);
        if (encoder == null) {
            throw new EncodingException("Error while encoding name value, needed encoder is missing!", new Object[0]);
        }
        this.writeXmlObject((XmlObject)encoder.encode((Object)name), GmlConstants.QN_NAME_32);
    }

    protected void writeDescription(String description) throws XMLStreamException {
        this.start(GmlConstants.QN_DESCRIPTION_32);
        this.chars(description);
        this.endInline(GmlConstants.QN_DESCRIPTION_32);
    }

    protected void writeMetadata(Map<String, NamedValue<?>> map, QName element) throws XMLStreamException, EncodingException {
        for (Map.Entry<String, NamedValue<?>> entry : map.entrySet()) {
            Object o = this.getEncoder("http://www.opengis.net/om/2.0", entry.getValue()).encode(entry.getValue(), EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT));
            if (o == null || !(o instanceof XmlObject)) continue;
            this.start(GetDataAvailabilityConstants.GDA_EXTENSION);
            this.attr("name", entry.getKey());
            this.rawText(((XmlObject)o).xmlText(this.getXmlOptions()));
            this.end(GetDataAvailabilityConstants.GDA_EXTENSION);
        }
    }

    protected void writeMetaDataProperty(List<AbstractMetaData> metaDataProperty) throws XMLStreamException, EncodingException {
        for (AbstractMetaData abstractMetaData : metaDataProperty) {
            Object o = this.getEncoder("http://www.opengis.net/gml/3.2", abstractMetaData).encode((Object)abstractMetaData, EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT));
            if (o == null || !(o instanceof XmlObject)) continue;
            this.start(GmlConstants.QN_OM_20_META_DATA_PROPERTY_32);
            this.rawText(((XmlObject)o).xmlText(this.getXmlOptions()));
            this.end(GmlConstants.QN_OM_20_META_DATA_PROPERTY_32);
        }
    }

    protected void writeObservationType(String observationType) throws XMLStreamException {
        this.empty(OmConstants.QN_OM_20_OBSERVATION_TYPE);
        this.addXlinkHrefAttr(observationType);
    }

    protected void writePhenomenonTime(Time time) throws EncodingException, XMLStreamException {
        this.start(OmConstants.QN_OM_20_PHENOMENON_TIME);
        this.writeTimeContent(time);
        this.end(OmConstants.QN_OM_20_PHENOMENON_TIME);
    }

    protected void writeValidTime(TimePeriod validTime) throws EncodingException, XMLStreamException {
        this.start(OmConstants.QN_OM_20_VALID_TIME);
        this.writeTimeContent((Time)validTime);
        this.end(OmConstants.QN_OM_20_VALID_TIME);
    }

    protected void writeResultTime() throws XMLStreamException, EncodingException {
        OmObservation observation = (OmObservation)this.getElement();
        TimeInstant resultTime = observation.getResultTime();
        Time phenomenonTime = observation.getPhenomenonTime();
        if (observation.getResultTime() != null) {
            if (resultTime.equals((Object)phenomenonTime)) {
                this.empty(OmConstants.QN_OM_20_RESULT_TIME);
                this.addXlinkHrefAttr("#".concat(phenomenonTime.getGmlId()));
            } else {
                this.addResultTime(resultTime);
            }
        } else if (phenomenonTime instanceof TimeInstant) {
            this.empty(OmConstants.QN_OM_20_RESULT_TIME);
            this.addXlinkHrefAttr("#".concat(phenomenonTime.getGmlId()));
        } else if (phenomenonTime instanceof TimePeriod) {
            TimeInstant rsTime = new TimeInstant(((TimePeriod)observation.getPhenomenonTime()).getEnd());
            this.addResultTime(rsTime);
        }
    }

    protected void writeProcedure() throws XMLStreamException, EncodingException {
        this.empty(OmConstants.QN_OM_20_PROCEDURE);
        OmObservation observation = (OmObservation)this.getElement();
        this.addXlinkHrefAttr(observation.getObservationConstellation().getProcedure().getIdentifier());
        if (observation.getObservationConstellation().getProcedure().isSetName() && observation.getObservationConstellation().getProcedure().getFirstName().isSetValue()) {
            this.addXlinkTitleAttr(observation.getObservationConstellation().getProcedure().getFirstName().getValue());
        }
    }

    protected void writeParameter() throws XMLStreamException, EncodingException {
        XmlEncoderKey key = new XmlEncoderKey("http://www.opengis.net/om/2.0", NamedValue.class);
        Encoder encoder = this.getEncoder((EncoderKey)key);
        if (encoder != null) {
            for (NamedValue namedValue : ((OmObservation)this.getElement()).getParameter()) {
                this.start(OmConstants.QN_OM_20_PARAMETER);
                this.writeXmlObject((XmlObject)encoder.encode((Object)namedValue), OmConstants.QN_OM_20_NAMED_VALUE);
                this.end(OmConstants.QN_OM_20_PARAMETER);
            }
        }
    }

    protected void writeObservableProperty() throws XMLStreamException {
        this.empty(OmConstants.QN_OM_20_OBSERVED_PROPERTY);
        OmObservation observation = (OmObservation)this.getElement();
        this.addXlinkHrefAttr(observation.getObservationConstellation().getObservableProperty().getIdentifier());
        if (observation.getObservationConstellation().getObservableProperty().isSetName() && observation.getObservationConstellation().getObservableProperty().getFirstName().isSetValue()) {
            this.addXlinkTitleAttr(observation.getObservationConstellation().getObservableProperty().getFirstName().getValue());
        }
    }

    protected void writeFeatureOfIntererst() throws XMLStreamException, EncodingException {
        Optional<String> namespace = this.getDefaultFeatureEncodingNamespace();
        AbstractFeature foi = ((OmObservation)this.getElement()).getObservationConstellation().getFeatureOfInterest();
        if (namespace.isPresent()) {
            EncodingContext codingContext = EncodingContext.of((Enum)XmlEncoderFlags.ENCODE_NAMESPACE, (Object)namespace.get());
            Encoder encoder = this.getEncoder("http://www.opengis.net/gml/3.2", foi);
            this.writeXmlObject((XmlObject)encoder.encode((Object)foi, codingContext), OmConstants.QN_OM_20_FEATURE_OF_INTEREST);
        } else {
            this.empty(OmConstants.QN_OM_20_FEATURE_OF_INTEREST);
            this.addXlinkHrefAttr(foi.getIdentifier());
            if (foi.isSetName() && foi.getFirstName().isSetValue()) {
                this.addXlinkTitleAttr(foi.getFirstName().getValue());
            }
        }
    }

    protected abstract Optional<String> getDefaultFeatureEncodingNamespace();

    protected void writeResult() throws XMLStreamException, EncodingException {
        XmlObject createResult;
        OmObservation observation = (OmObservation)this.getElement();
        if (observation.getValue() instanceof AbstractObservationValue) {
            ((AbstractObservationValue)observation.getValue()).setValuesForResultEncoding(observation);
        }
        if ((createResult = (XmlObject)this.getEncoder(this.getEncodeNamespace().orElse("http://www.opengis.net/om/2.0"), observation.getValue()).encode((Object)observation.getValue())) != null) {
            if (createResult.xmlText().contains("xml-fragment")) {
                XmlObject set = OMObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions()).addNewResult().set(createResult);
                this.writeXmlObject(set, OmConstants.QN_OM_20_RESULT);
            } else if (this.checkResult(createResult)) {
                QName name = createResult.schemaType().getName();
                String prefix = name.getPrefix();
                if (Strings.isNullOrEmpty((String)prefix)) {
                    XmlCursor newCursor = createResult.newCursor();
                    prefix = newCursor.prefixForNamespace(name.getNamespaceURI());
                    newCursor.setAttributeText(W3CConstants.QN_XSI_TYPE, prefix + ":" + name.getLocalPart());
                    newCursor.dispose();
                }
                this.writeXmlObject(createResult, OmConstants.QN_OM_20_RESULT);
            } else {
                this.start(OmConstants.QN_OM_20_RESULT);
                this.writeXmlObject(createResult, OmConstants.QN_OM_20_RESULT);
                this.end(OmConstants.QN_OM_20_RESULT);
            }
        } else {
            this.empty(OmConstants.QN_OM_20_RESULT);
        }
    }

    protected EncodingContext getDocumentAdditionalHelperValues() {
        return EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT);
    }

    protected String getTimeString(Time time) throws DateTimeFormatException {
        DateTime dateTime = this.getTime(time);
        return DateTimeHelper.formatDateTime2String((DateTime)dateTime, (Time.TimeFormat)time.getTimeFormat());
    }

    protected QName getDocumentName() {
        return OmConstants.QN_OM_20_OBSERVATION;
    }

    private boolean checkResult(XmlObject result) {
        QName name;
        SchemaType schemaType;
        return result.schemaType() != null && (schemaType = result.schemaType()).getName() != null && (name = schemaType.getName()).getLocalPart() != null && name.getLocalPart().toLowerCase(Locale.ROOT).contains("propertytype");
    }

    private String addGmlId(OmObservation observation) throws XMLStreamException {
        String observationID = JavaHelper.generateID((String)Double.toString((double)System.currentTimeMillis() * Math.random()));
        if (observation.isSetObservationID()) {
            observationID = observation.getObservationID();
        } else {
            observation.setObservationID(observationID);
        }
        this.attr(GmlConstants.QN_ID_32, "o_" + observationID);
        return observationID;
    }

    private void writeTimeContent(Time time) throws EncodingException, XMLStreamException {
        XmlObject xmlObject = (XmlObject)this.getEncoder("http://www.opengis.net/gml/3.2", time).encode((Object)time, this.getDocumentAdditionalHelperValues());
        this.writeXmlObject(xmlObject, GmlHelper.getGml321QnameForITime((Time)time));
    }

    private void addResultTime(TimeInstant time) throws EncodingException, XMLStreamException {
        this.start(OmConstants.QN_OM_20_RESULT_TIME);
        XmlObject xmlObject = (XmlObject)this.getEncoder("http://www.opengis.net/gml/3.2", time).encode((Object)time, this.getDocumentAdditionalHelperValues());
        this.writeXmlObject(xmlObject, GmlConstants.QN_TIME_INSTANT_32);
        this.end(OmConstants.QN_OM_20_RESULT_TIME);
    }

    private DateTime getTime(Time time) {
        if (time instanceof TimeInstant) {
            return ((TimeInstant)time).getValue();
        }
        if (time instanceof TimePeriod) {
            TimePeriod timePeriod = (TimePeriod)time;
            if (timePeriod.getEnd() != null) {
                return timePeriod.getEnd();
            }
            return timePeriod.getStart();
        }
        return new DateTime().minusYears(1000);
    }
}

