/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AqdGetObservationResponseXmlStreamWriter
extends XmlStreamWriter<FeatureCollection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AqdGetObservationResponseXmlStreamWriter.class);
    private static final long TIMER_PERIOD = 250L;
    private Timer timer = new Timer(String.format("empty-string-write-task-for-%s", this.getClass().getSimpleName()), true);
    private TimerTask timerTask;

    public AqdGetObservationResponseXmlStreamWriter(EncodingContext context, OutputStream outputStream, FeatureCollection element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    public void write() throws XMLStreamException, EncodingException {
        try {
            this.start();
            this.writeFeatureCollectionDoc();
            this.end();
            this.finish();
        }
        finally {
            this.cleanup();
        }
    }

    private void writeFeatureCollectionDoc() throws XMLStreamException, EncodingException {
        this.start(GmlConstants.QN_FEATURE_COLLECTION_32);
        this.addNamespaces();
        this.addSchemaLocations();
        FeatureCollection featureCollection = (FeatureCollection)this.getElement();
        this.addGmlId(featureCollection.getGmlId());
        TimeInstant resultTime = new TimeInstant(new DateTime(DateTimeZone.UTC));
        for (AbstractFeature abstractFeature : featureCollection.getMembers().values()) {
            long start = System.currentTimeMillis();
            Encoder<XmlObject, AbstractFeature> encoder = this.getEncoder(abstractFeature);
            if (abstractFeature instanceof OmObservation) {
                OmObservation observation = (OmObservation)abstractFeature;
                if (observation.getValue() instanceof ObservationStream) {
                    try {
                        this.startTimer();
                        ObservationStream mergeObservation = ((ObservationStream)observation.getValue()).merge();
                        LOGGER.debug("Observation processing requires {} ms", (Object)(System.currentTimeMillis() - start));
                        int count = 0;
                        while (mergeObservation.hasNext()) {
                            OmObservation omObservation = (OmObservation)mergeObservation.next();
                            if (abstractFeature.isSetGmlID()) {
                                if (count == 0) {
                                    omObservation.setGmlId(abstractFeature.getGmlId());
                                } else {
                                    omObservation.setGmlId(abstractFeature.getGmlId() + "_" + count);
                                }
                                ++count;
                            }
                            omObservation.setResultTime(resultTime);
                            String xmlTextObservation = this.prepareObservation(omObservation, encoder);
                            this.stopTimer();
                            this.writeMember(xmlTextObservation);
                        }
                    }
                    catch (OwsExceptionReport ex) {
                        throw new EncodingException((Throwable)ex);
                    }
                } else {
                    this.writeMember(abstractFeature, encoder);
                }
            } else {
                this.writeMember(abstractFeature, encoder);
            }
            LOGGER.debug("Writing member requires {} ms", (Object)(System.currentTimeMillis() - start));
        }
        this.end(GmlConstants.QN_FEATURE_COLLECTION_32);
    }

    private void addNamespaces() throws XMLStreamException {
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.namespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespace("om", "http://www.opengis.net/om/2.0");
        this.namespace("gml", "http://www.opengis.net/gml/3.2");
        this.namespace("swe", "http://www.opengis.net/swe/2.0");
        this.namespace("sams", "http://www.opengis.net/samplingSpatial/2.0");
        this.namespace("sam", "http://www.opengis.net/sampling/2.0");
        this.namespace("gmd", "http://www.isotc211.org/2005/gmd");
        this.namespace("gco", "http://www.isotc211.org/2005/gco");
        this.namespace("aqd", "http://dd.eionet.europa.eu/schemaset/id2011850eu-1.0");
        this.namespace("am", "http://inspire.ec.europa.eu/schemas/am/3.0");
        this.namespace("base", "http://inspire.ec.europa.eu/schemas/base/3.3");
        this.namespace("base2", "http://inspire.ec.europa.eu/schemas/base2/1.0");
        this.namespace("ompr", "http://inspire.ec.europa.eu/schemas/ompr/2.0");
        this.namespace("ef", "http://inspire.ec.europa.eu/schemas/ef/3.0");
        this.namespace("gn", "urn:x-inspire:specification:gmlas:GeographicalNames:3.0");
        this.namespace("ad", "urn:x-inspire:specification:gmlas:Addresses:3.0");
    }

    private void addSchemaLocations() throws XMLStreamException {
        HashSet schemaLocations = Sets.newHashSet();
        schemaLocations.add(AqdConstants.NS_AQD_SCHEMA_LOCATION);
        schemaLocations.add(GmlConstants.GML_32_SCHEMAL_LOCATION);
        schemaLocations.add(OmConstants.OM_20_SCHEMA_LOCATION);
        schemaLocations.add(SweConstants.SWE_20_SCHEMA_LOCATION);
        this.schemaLocation(schemaLocations);
    }

    private String addGmlId(String gmlId) throws XMLStreamException {
        this.attr(GmlConstants.QN_ID_32, gmlId);
        return gmlId;
    }

    private String prepareObservation(OmObservation omObservation, Encoder<XmlObject, AbstractFeature> encoder) throws EncodingException, XMLStreamException {
        String xmlText = ((XmlObject)encoder.encode((Object)omObservation, this.getContext())).xmlText(this.getXmlOptions());
        xmlText = xmlText.replace("ns:ReferenceType", "gml:ReferenceType");
        xmlText = xmlText.replace(":ns=\"http://www.opengis.net/gml/3.2\"", ":gml=\"http://www.opengis.net/gml/3.2\"");
        xmlText = xmlText.replace("ns:DataArrayPropertyType", "swe:DataArrayPropertyType");
        xmlText = xmlText.replace(":ns=\"http://www.opengis.net/swe/2.0\"", ":swe=\"http://www.opengis.net/swe/2.0\"");
        xmlText = xmlText.replace("<ns:", "<swe:");
        xmlText = xmlText.replace("</ns:", "</swe:");
        return xmlText;
    }

    private void writeMember(AbstractFeature abstractFeature, Encoder<XmlObject, AbstractFeature> encoder) throws XMLStreamException, EncodingException {
        this.writeXmlObject((XmlObject)encoder.encode((Object)abstractFeature, this.getContext()));
    }

    private void writeMember(String memberContent) throws XMLStreamException, EncodingException {
        this.start(GmlConstants.QN_FEATURE_MEMBER_32);
        this.rawText(memberContent);
        this.end(GmlConstants.QN_FEATURE_MEMBER_32);
    }

    private Encoder<XmlObject, AbstractFeature> getEncoder(AbstractFeature feature) throws EncodingException {
        if (feature.isSetDefaultElementEncoding()) {
            return this.getEncoder(CodingHelper.getEncoderKey((String)feature.getDefaultElementEncoding(), (Object)feature));
        }
        if (this.getEncodeNamespace().isPresent()) {
            return this.getEncoder(CodingHelper.getEncoderKey((String)this.getEncodeNamespace().get(), (Object)feature));
        }
        return null;
    }

    private void initTimer() {
        this.timerTask = new WriteTimerTask();
    }

    private void startTimer() {
        if (this.timerTask == null) {
            this.initTimer();
        }
        this.timer.schedule(this.timerTask, 250L, 250L);
        LOGGER.debug("Timer started!");
    }

    private void stopTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
            LOGGER.debug("Timer task {} canceled", (Object)WriteTimerTask.class.getSimpleName());
        }
    }

    private void cleanup() {
        this.stopTimer();
        this.timerTask = null;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class WriteTimerTask
    extends TimerTask {
        private WriteTimerTask() {
        }

        @Override
        public void run() {
            try {
                AqdGetObservationResponseXmlStreamWriter.this.chars("");
                AqdGetObservationResponseXmlStreamWriter.this.flush();
            }
            catch (XMLStreamException xmlse) {
                AqdGetObservationResponseXmlStreamWriter.this.cleanup();
                LOGGER.error("Error while writing empty string by timer task!", (Throwable)xmlse);
            }
        }
    }
}

