/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.base.Optional;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.joda.time.DateTime;
import org.n52.janmayen.NcName;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.aqd.EReportingChange;
import org.n52.shetland.aqd.EReportingHeader;
import org.n52.shetland.inspire.GeographicalName;
import org.n52.shetland.inspire.Pronunciation;
import org.n52.shetland.inspire.Spelling;
import org.n52.shetland.inspire.ad.AddressRepresentation;
import org.n52.shetland.inspire.base.Identifier;
import org.n52.shetland.inspire.base2.Contact;
import org.n52.shetland.inspire.base2.RelatedParty;
import org.n52.shetland.iso.GcoConstants;
import org.n52.shetland.iso.gmd.LocalisedCharacterString;
import org.n52.shetland.iso.gmd.PT_FreeText;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.JavaHelper;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.XmlStreamWriter;

public class EReportingHeaderEncoder
extends XmlStreamWriter<EReportingHeader> {
    public EReportingHeaderEncoder(EncodingContext context, OutputStream outputStream, EReportingHeader element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    public void write() throws XMLStreamException, EncodingException {
        EReportingHeader h = (EReportingHeader)this.getElement();
        this.start(AqdConstants.QN_AQD_REPORTING_HEADER);
        this.namespace("ad", "urn:x-inspire:specification:gmlas:Addresses:3.0");
        this.namespace("aqd", "http://dd.eionet.europa.eu/schemaset/id2011850eu-1.0");
        this.namespace("base", "http://inspire.ec.europa.eu/schemas/base/3.3");
        this.namespace("base2", "http://inspire.ec.europa.eu/schemas/base2/1.0");
        this.namespace("gn", "urn:x-inspire:specification:gmlas:GeographicalNames:3.0");
        this.namespace("gml", "http://www.opengis.net/gml/3.2");
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.namespace("gco", "http://www.isotc211.org/2005/gco");
        if (this.isAddSchemaLocation()) {
            this.schemaLocation(Collections.singleton(AqdConstants.NS_AQD_SCHEMA_LOCATION));
        }
        this.attr(GmlConstants.QN_ID_32, this.getGMLId(h));
        this.encodeChange(h.getChange());
        this.encodeInpireID(h.getInspireID());
        this.encodeReportingAuthority(h.getReportingAuthority());
        this.encodeReportingPeriod((Referenceable<? extends Time>)h.getReportingPeriod());
        if (h.isSetContent()) {
            this.encodeContent(h.getContent());
        }
        this.end(AqdConstants.QN_AQD_REPORTING_HEADER);
    }

    protected String getGMLId(Object h) {
        String gmlId = JavaHelper.generateID((String)(h.toString() + System.currentTimeMillis()));
        return NcName.makeValid((String)gmlId);
    }

    private void encodeReportingPeriod(Referenceable<? extends Time> v) throws XMLStreamException, EncodingException {
        if (!v.isAbsent()) {
            if (v.isReference()) {
                this.empty(AqdConstants.QN_AQD_REPORTING_PERIOD);
                this.encodeReferenceAttr(v.getReference());
            } else if (v.getInstance().isNil()) {
                this.empty(AqdConstants.QN_AQD_REPORTING_PERIOD);
                this.encodeNilAttr((Optional<String>)v.getInstance().getNilReason());
            } else {
                this.start(AqdConstants.QN_AQD_REPORTING_PERIOD);
                this.encodeTime((Time)v.getInstance().get());
                this.end(AqdConstants.QN_AQD_REPORTING_PERIOD);
            }
        }
    }

    private void encodeReportingAuthority(RelatedParty v) throws XMLStreamException {
        this.start(AqdConstants.QN_AQD_REPORTING_AUTHORITY);
        this.encodeRelatedParty(v);
        this.end(AqdConstants.QN_AQD_REPORTING_AUTHORITY);
    }

    private void encodeInpireID(Identifier v) throws XMLStreamException {
        this.start(AqdConstants.QN_AQD_INSPIRE_ID);
        this.start(AqdConstants.QN_BASE_IDENTIFIER);
        this.encodeString(AqdConstants.QN_BASE_LOCAL_ID, v.getLocalId());
        this.encodeString(AqdConstants.QN_BASE_NAMESPACE, v.getNamespace());
        this.encodeNillableString(AqdConstants.QN_BASE_VERSION_ID, v.getVersionId());
        this.end(AqdConstants.QN_BASE_IDENTIFIER);
        this.end(AqdConstants.QN_AQD_INSPIRE_ID);
    }

    private void encodeChange(EReportingChange v) throws XMLStreamException {
        this.start(AqdConstants.QN_AQD_CHANGE);
        this.chars(Boolean.toString(v.isChange()));
        this.endInline(AqdConstants.QN_AQD_CHANGE);
        if (v.getDescription().isPresent()) {
            this.start(AqdConstants.QN_AQD_CHANGE_DESCRIPTION);
            this.chars((String)v.getDescription().get());
            this.endInline(AqdConstants.QN_AQD_CHANGE_DESCRIPTION);
        }
    }

    private void encodeRelatedParty(RelatedParty v) throws XMLStreamException {
        this.start(AqdConstants.QN_BASE2_RELATED_PARTY);
        this.encodeNillableFreeText(AqdConstants.QN_BASE2_INDIVIDUAL_NAME, (Nillable<PT_FreeText>)v.getIndividualName());
        this.encodeNillableFreeText(AqdConstants.QN_BASE2_ORGANISATION_NAME, (Nillable<PT_FreeText>)v.getOrganisationName());
        this.encodeNillableFreeText(AqdConstants.QN_BASE2_POSITION_NAME, (Nillable<PT_FreeText>)v.getPositionName());
        this.encodeContact((Nillable<Contact>)v.getContact());
        for (Nillable role : v.getRoles()) {
            this.encodeNillableReference(AqdConstants.QN_BASE2_ROLE, (Nillable<Reference>)role);
        }
        this.end(AqdConstants.QN_BASE2_RELATED_PARTY);
    }

    private void encodeContent(List<Referenceable<AbstractFeature>> content) throws XMLStreamException {
        for (Referenceable<AbstractFeature> v : content) {
            if (v.isReference()) {
                this.empty(AqdConstants.QN_AQD_CONTENT);
                this.encodeReferenceAttr(v.getReference());
                continue;
            }
            this.empty(AqdConstants.QN_AQD_CONTENT);
            this.attr(W3CConstants.QN_XLINK_HREF, ((AbstractFeature)v.getInstance().get()).getIdentifier());
        }
    }

    private void encodeReferenceAttr(Reference v) throws XMLStreamException {
        this.attr(W3CConstants.QN_XLINK_HREF, v.getHref());
        this.attr(W3CConstants.QN_XLINK_ACTUATE, v.getActuate());
        this.attr(W3CConstants.QN_XLINK_ARCROLE, v.getArcrole());
        this.attr(W3CConstants.QN_XLINK_ROLE, v.getRole());
        this.attr(W3CConstants.QN_XLINK_SHOW, v.getShow());
        this.attr(W3CConstants.QN_XLINK_TITLE, v.getTitle());
        this.attr(W3CConstants.QN_XLINK_TYPE, v.getType());
        this.attr(GmlConstants.QN_REMOTE_SCHEMA, v.getRemoteSchema());
    }

    protected void attr(QName qn, Optional<?> v) throws XMLStreamException {
        if (v.isPresent()) {
            this.attr(qn, v.get().toString());
        }
    }

    protected void encodeNillableString(QName qn, Nillable<?> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            if (v.isNil()) {
                this.empty(qn);
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.start(qn);
                this.chars(v.get().toString());
                this.endInline(qn);
            }
        }
    }

    protected void encodeString(QName qn, String v) throws XMLStreamException {
        this.start(qn);
        this.chars(v);
        this.endInline(qn);
    }

    private void encodeNilAttr(Optional<String> reason) throws XMLStreamException {
        this.attr(W3CConstants.QN_XSI_NIL, Boolean.toString(true));
        if (reason.isPresent()) {
            this.attr("nilReason", (String)reason.get());
        }
    }

    private void encodeGCONilAttr(Nillable<?> v) throws XMLStreamException {
        if (v.isNil()) {
            this.attr(W3CConstants.QN_XSI_NIL, Boolean.toString(true));
            if (v.getNilReason().isPresent()) {
                this.attr(GcoConstants.QN_GCO_NIL_REASON, (String)v.getNilReason().get());
            }
        }
    }

    protected void encodeNillableFreeText(QName qn, Nillable<PT_FreeText> nillable) throws XMLStreamException {
        if (!nillable.isAbsent()) {
            if (nillable.isNil()) {
                this.empty(qn);
                this.encodeGCONilAttr(nillable);
            } else {
                for (LocalisedCharacterString lcs : ((PT_FreeText)nillable.get()).getTextGroup()) {
                    this.start(qn);
                    this.start(GcoConstants.QN_GCO_CHARACTER_STRING);
                    this.chars(lcs.getValue());
                    this.endInline(GcoConstants.QN_GCO_CHARACTER_STRING);
                    this.end(qn);
                }
            }
        }
    }

    private void encodeContact(Nillable<Contact> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            if (v.isNil()) {
                this.empty(AqdConstants.QN_BASE2_CONTACT);
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.start(AqdConstants.QN_BASE2_CONTACT);
                this.encodeContact((Contact)v.get());
                this.end(AqdConstants.QN_BASE2_CONTACT);
            }
        }
    }

    protected void encodeContact(Contact c) throws XMLStreamException {
        this.start(AqdConstants.QN_BASE2_C_ONTACT);
        this.encodeAddress((Nillable<AddressRepresentation>)c.getAddress());
        this.encodeNillableFreeText(AqdConstants.QN_BASE2_CONTACT_INSTRUCTIONS, (Nillable<PT_FreeText>)c.getContactInstructions());
        this.encodeNillableString(AqdConstants.QN_BASE2_ELECTRONIC_MAIL_ADDRESS, c.getElectronicMailAddress());
        this.encodeNillableFreeText(AqdConstants.QN_BASE2_HOURS_OF_SERVICE, (Nillable<PT_FreeText>)c.getHoursOfService());
        if (c.getTelephoneFacsimile().isPresent()) {
            for (Nillable value : (List)c.getTelephoneFacsimile().get()) {
                this.encodeNillableString(AqdConstants.QN_BASE2_TELEPHONE_FACSIMILE, value);
            }
        }
        if (c.getTelephoneVoice().isPresent()) {
            for (Nillable value : (List)c.getTelephoneVoice().get()) {
                this.encodeNillableString(AqdConstants.QN_BASE2_TELEPHONE_VOICE, value);
            }
        }
        this.encodeNillableString(AqdConstants.QN_BASE2_WEBSITE, c.getWebsite());
        this.end(AqdConstants.QN_BASE2_C_ONTACT);
    }

    private void encodeAddress(Nillable<AddressRepresentation> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            if (v.isNil()) {
                this.empty(AqdConstants.QN_BASE2_ADDRESS);
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.start(AqdConstants.QN_BASE2_ADDRESS);
                this.encodeAddress((AddressRepresentation)v.get());
                this.end(AqdConstants.QN_BASE2_ADDRESS);
            }
        }
    }

    private void encodeAddress(AddressRepresentation v) throws XMLStreamException {
        this.start(AqdConstants.QN_AD_ADDRESS_REPRESENTATION);
        for (Object value : v.getAdminUnits()) {
            this.start(AqdConstants.QN_AD_ADMIN_UNIT);
            this.encodeGeographicalName((GeographicalName)value);
            this.end(AqdConstants.QN_AD_ADMIN_UNIT);
        }
        for (Object value : v.getLocatorDesignators()) {
            this.start(AqdConstants.QN_AD_LOCATOR_DESIGNATOR);
            this.chars((String)value);
            this.endInline(AqdConstants.QN_AD_LOCATOR_DESIGNATOR);
        }
        for (Object value : v.getLocatorNames()) {
            this.start(AqdConstants.QN_AD_LOCATOR_NAME);
            this.encodeGeographicalName((GeographicalName)value);
            this.end(AqdConstants.QN_AD_LOCATOR_NAME);
        }
        for (Object value : v.getAddressAreas()) {
            this.encodeNillableGeographicalName(AqdConstants.QN_AD_ADDRESS_AREA, (Nillable<GeographicalName>)value);
        }
        for (Object value : v.getPostNames()) {
            this.encodeNillableGeographicalName(AqdConstants.QN_AD_POST_NAME, (Nillable<GeographicalName>)value);
        }
        this.encodeNillableString(AqdConstants.QN_AD_POST_CODE, v.getPostCode());
        for (Object value : v.getThoroughfares()) {
            this.encodeNillableGeographicalName(AqdConstants.QN_AD_THOROUGHFARE, (Nillable<GeographicalName>)value);
        }
        this.encodeNillableReference(AqdConstants.QN_AD_ADDRESS_FEATURE, (Nillable<Reference>)v.getAddressFeature());
        this.end(AqdConstants.QN_AD_ADDRESS_REPRESENTATION);
    }

    protected void encodeNillableGeographicalName(QName qn, Nillable<GeographicalName> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            if (v.isNil()) {
                this.empty(qn);
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.start(qn);
                this.encodeGeographicalName((GeographicalName)v.get());
                this.end(qn);
            }
        }
    }

    protected void encodeNillableReference(QName qn, Nillable<Reference> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            this.empty(qn);
            if (v.isNil()) {
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.encodeReferenceAttr((Reference)v.get());
            }
        }
    }

    private void encodeGeographicalName(GeographicalName v) throws XMLStreamException {
        this.start(AqdConstants.QN_GN_GEOGRAPHICAL_NAME);
        this.encodeNillableString(AqdConstants.QN_GN_LANGUAGE, v.getLanguage());
        this.encodeNillableCodeType(AqdConstants.QN_GN_NATIVENESS, (Nillable<CodeType>)v.getNativeness());
        this.encodeNillableCodeType(AqdConstants.QN_GN_NAME_STATUS, (Nillable<CodeType>)v.getNameStatus());
        this.encodeNillableString(AqdConstants.QN_GN_SOURCE_OF_NAME, v.getSourceOfName());
        this.encodeNillablePronunciation(AqdConstants.QN_GN_PRONUNCIATION, (Nillable<Pronunciation>)v.getPronunciation());
        for (Spelling value : v.getSpelling()) {
            this.start(AqdConstants.QN_GN_SPELLING);
            this.encodeSpellingOfName(value);
            this.end(AqdConstants.QN_GN_SPELLING);
        }
        this.encodeNillableCodeType(AqdConstants.QN_GN_GRAMMATICAL_GENDER, (Nillable<CodeType>)v.getGrammaticalGender());
        this.encodeNillableCodeType(AqdConstants.QN_GN_GRAMMATICAL_NUMBER, (Nillable<CodeType>)v.getGrammaticalNumber());
        this.end(AqdConstants.QN_GN_GEOGRAPHICAL_NAME);
    }

    protected void encodeNillableCodeType(QName qn, Nillable<CodeType> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            if (v.isNil()) {
                this.empty(qn);
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.start(qn);
                if (((CodeType)v.get()).isSetCodeSpace()) {
                    this.attr("codeSpace", ((CodeType)v.get()).getCodeSpace().toString());
                }
                this.chars(((CodeType)v.get()).getValue());
                this.endInline(qn);
            }
        }
    }

    protected void encodeNillablePronunciation(QName qn, Nillable<Pronunciation> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            if (v.isNil()) {
                this.empty(qn);
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.start(qn);
                this.encodePronunciationOfName((Pronunciation)v.get());
                this.end(qn);
            }
        }
    }

    protected void encodePronunciationOfName(Pronunciation pronunciation) throws XMLStreamException {
        this.start(AqdConstants.QN_GN_PRONUNCIATION_OF_NAME);
        this.encodeNillableString(AqdConstants.QN_GN_PRONUNCIATION_SOUND_LINK, pronunciation.getSoundLink());
        this.encodeNillableString(AqdConstants.QN_GN_PRONUNCIATION_IPA, pronunciation.getIPA());
        this.end(AqdConstants.QN_GN_PRONUNCIATION_OF_NAME);
    }

    protected void encodeNillableSpelling(QName qn, Nillable<Spelling> v) throws XMLStreamException {
        if (!v.isAbsent()) {
            if (v.isNil()) {
                this.empty(qn);
                this.encodeNilAttr((Optional<String>)v.getNilReason());
            } else {
                this.start(qn);
                this.encodeSpellingOfName((Spelling)v.get());
                this.end(qn);
            }
        }
    }

    protected void encodeSpellingOfName(Spelling spelling) throws XMLStreamException {
        this.start(AqdConstants.QN_GN_SPELLING_OF_NAME);
        this.encodeString(AqdConstants.QN_GN_TEXT, spelling.getText());
        this.encodeNillableString(AqdConstants.QN_GN_SCRIPT, spelling.getScript());
        this.encodeNillableString(AqdConstants.QN_GN_TRANSLITERATION_SCHEME, spelling.getTransliterationScheme());
        this.end(AqdConstants.QN_GN_SPELLING_OF_NAME);
    }

    private void encodeTime(Time v) throws XMLStreamException, EncodingException {
        if (v instanceof TimePeriod) {
            this.encodeTimePeriod((TimePeriod)v);
        } else if (v instanceof TimeInstant) {
            this.encodeTimeInstant((TimeInstant)v);
        }
    }

    private void encodeTimeInstant(TimeInstant ti) throws XMLStreamException, EncodingException {
        this.start(GmlConstants.QN_TIME_INSTANT_32);
        this.attr(GmlConstants.QN_ID_32, this.getGMLId(ti));
        this.start(GmlConstants.QN_TIME_POSITION_32);
        this.encodeTimeString(ti.getValue(), ti.getTimeFormat());
        this.endInline(GmlConstants.QN_TIME_POSITION_32);
        this.end(GmlConstants.QN_TIME_INSTANT_32);
    }

    private void encodeTimePeriod(TimePeriod tp) throws XMLStreamException, EncodingException {
        this.start(GmlConstants.QN_TIME_PERIOD_32);
        this.attr(GmlConstants.QN_ID_32, this.getGMLId(tp));
        this.start(GmlConstants.QN_BEGIN_POSITION_32);
        this.encodeTimeString(tp.getStart(), tp.getTimeFormat());
        this.endInline(GmlConstants.QN_BEGIN_POSITION_32);
        this.start(GmlConstants.QN_END_POSITION_32);
        this.encodeTimeString(tp.getEnd(), tp.getTimeFormat());
        this.endInline(GmlConstants.QN_END_POSITION_32);
        this.end(GmlConstants.QN_TIME_PERIOD_32);
    }

    protected void encodeTimeString(DateTime time, Time.TimeFormat format) throws XMLStreamException, EncodingException {
        this.chars(DateTimeHelper.formatDateTime2String((DateTime)time, (Time.TimeFormat)format));
    }
}

