/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityConstants;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.AbstractGetDataAvailabilityStreamWriter;

public class GetDataAvailabilityStreamWriter
extends AbstractGetDataAvailabilityStreamWriter {
    public GetDataAvailabilityStreamWriter(EncodingContext context, OutputStream outputStream, List<GetDataAvailabilityResponse.DataAvailability> element) throws XMLStreamException {
        super(context, outputStream, Optional.ofNullable(element).orElseGet(Collections::emptyList));
    }

    @Override
    public void write() throws XMLStreamException, EncodingException {
        this.start();
        this.writeGetDataAvailabilityResponse();
        this.end();
        this.finish();
    }

    @Override
    protected void writeGetDataAvailabilityResponse() throws XMLStreamException, EncodingException {
        this.start(GetDataAvailabilityConstants.GDA_GET_DATA_AVAILABILITY_RESPONSE);
        this.namespace("gda", "http://www.opengis.net/sosgda/1.0");
        this.namespace("gml", "http://www.opengis.net/gml/3.2");
        this.namespace("swe", "http://www.opengis.net/swe/2.0");
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.schemaLocation(Sets.newHashSet((Object[])new SchemaLocation[]{GetDataAvailabilityConstants.GET_DATA_AVAILABILITY_SCHEMA_LOCATION}));
        for (GetDataAvailabilityResponse.DataAvailability da : (List)this.getElement()) {
            this.wirteDataAvailabilityMember(da);
        }
        this.end(GetDataAvailabilityConstants.GDA_GET_DATA_AVAILABILITY_RESPONSE);
    }

    @Override
    protected void wirteDataAvailabilityMember(GetDataAvailabilityResponse.DataAvailability da) throws XMLStreamException, EncodingException {
        this.start(GetDataAvailabilityConstants.GDA_DATA_AVAILABILITY_MEMBER);
        this.attr(GmlConstants.QN_ID_32, "dam_" + this.dataAvailabilityCount++);
        this.writeProcedure(da, GetDataAvailabilityConstants.GDA_PROCEDURE);
        this.writeObservedProperty(da, GetDataAvailabilityConstants.GDA_OBSERVED_PROPERTY);
        this.writeFeatureOfInterest(da, GetDataAvailabilityConstants.GDA_FEATURE_OF_INTEREST);
        this.writePhenomenonTime(da, GetDataAvailabilityConstants.GDA_PHENOMENON_TIME);
        if (da.isSetCount()) {
            this.writeCount(da.getCount(), GetDataAvailabilityConstants.GDA_COUNT);
        }
        if (da.isSetResultTime()) {
            this.writeResultTimes(da.getResultTimes(), GetDataAvailabilityConstants.GDA_EXTENSION);
        }
        if (da.isSetOffering()) {
            this.writeOffering(da.getOffering(), GetDataAvailabilityConstants.GDA_EXTENSION);
        }
        if (da.isSetFormatDescriptors()) {
            Set<String> observationTypes = da.getFormatDescriptor().getObservationFormatDescriptors().stream().map(GetDataAvailabilityResponse.ObservationFormatDescriptor::getObservationTypes).flatMap(Collection::stream).collect(Collectors.toSet());
            this.writeObservationTypes(observationTypes);
        }
        if (da.isSetMetadata()) {
            this.writeMetadata(da.getMetadata(), GetDataAvailabilityConstants.GDA_EXTENSION);
        }
        this.end(GetDataAvailabilityConstants.GDA_DATA_AVAILABILITY_MEMBER);
    }

    protected void writeOffering(ReferenceType offering, QName element) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_EXTENSION);
        this.writeSweText("offering", offering.getHref());
        this.end(GetDataAvailabilityConstants.GDA_EXTENSION);
    }

    protected void writeObservationTypes(Set<String> observationTypes) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_EXTENSION);
        this.start(SweConstants.QN_DATA_RECORD_SWE_200);
        this.attr("definition", "observationTypes");
        int observationTypeCount = 1;
        for (String observationType : observationTypes) {
            this.start(SweConstants.QN_FIELD_200);
            this.attr("name", "observationType_" + observationTypeCount++);
            this.writeSweText("observationType", observationType);
            this.end(SweConstants.QN_FIELD_200);
        }
        this.end(SweConstants.QN_DATA_RECORD_SWE_200);
        this.end(GetDataAvailabilityConstants.GDA_EXTENSION);
    }

    private void writeSweText(String definition, String value) throws XMLStreamException {
        this.start(SweConstants.QN_TEXT_SWE_200);
        this.attr("definition", definition);
        this.writeSweValue(value);
        this.end(SweConstants.QN_TEXT_SWE_200);
    }
}

