/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityConstants;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.AbstractGetDataAvailabilityStreamWriter;

public class GetDataAvailabilityV20StreamWriter
extends AbstractGetDataAvailabilityStreamWriter {
    public GetDataAvailabilityV20StreamWriter(EncodingContext context, OutputStream outputStream, List<GetDataAvailabilityResponse.DataAvailability> element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    protected void writeGetDataAvailabilityResponse() throws XMLStreamException, EncodingException {
        this.start(GetDataAvailabilityConstants.GDA_GET_DATA_AVAILABILITY_20_RESPONSE);
        this.namespace("gda", "http://www.opengis.net/sosgda/2.0");
        this.namespace("gml", "http://www.opengis.net/gml/3.2");
        this.namespace("swe", "http://www.opengis.net/swe/2.0");
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.schemaLocation(Sets.newHashSet((Object[])new SchemaLocation[]{GetDataAvailabilityConstants.GET_DATA_AVAILABILITY_20_SCHEMA_LOCATION}));
        for (GetDataAvailabilityResponse.DataAvailability da : (List)this.getElement()) {
            this.wirteDataAvailabilityMember(da);
        }
        this.end(GetDataAvailabilityConstants.GDA_GET_DATA_AVAILABILITY_20_RESPONSE);
    }

    protected void writeOffering(ReferenceType offering) throws XMLStreamException {
        this.empty(GetDataAvailabilityConstants.GDA_20_OFFERING);
        this.attr(GetDataAvailabilityConstants.XLINK_HREF, offering.getHref());
        if (offering.isSetTitle()) {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, offering.getTitle());
        } else {
            this.attr(GetDataAvailabilityConstants.XLINK_TITLE, offering.getTitleOrFromHref());
        }
    }

    @Override
    protected void wirteDataAvailabilityMember(GetDataAvailabilityResponse.DataAvailability da) throws XMLStreamException, EncodingException {
        this.start(GetDataAvailabilityConstants.GDA_DATA_AVAILABILITY_20_MEMBER);
        this.attr(GmlConstants.QN_ID_32, "dam_" + this.dataAvailabilityCount++);
        this.writeProcedure(da, GetDataAvailabilityConstants.GDA_20_PROCEDURE);
        this.writeObservedProperty(da, GetDataAvailabilityConstants.GDA_20_OBSERVED_PROPERTY);
        this.writeFeatureOfInterest(da, GetDataAvailabilityConstants.GDA_20_FEATURE_OF_INTEREST);
        this.writePhenomenonTime(da, GetDataAvailabilityConstants.GDA_20PHENOMENON_TIME);
        if (da.isSetCount()) {
            this.writeCount(da.getCount(), GetDataAvailabilityConstants.GDA_20_COUNT);
        }
        if (da.isSetResultTime()) {
            this.writeResultTimes(da.getResultTimes(), GetDataAvailabilityConstants.GDA_20_EXTENSION);
        }
        if (da.isSetOffering()) {
            this.writeOffering(da.getOffering());
        }
        if (da.isSetFormatDescriptors()) {
            this.writeFormatDescriptor(da.getFormatDescriptor());
        }
        if (da.isSetMetadata()) {
            this.writeMetadata(da.getMetadata(), GetDataAvailabilityConstants.GDA_20_EXTENSION);
        }
        this.end(GetDataAvailabilityConstants.GDA_DATA_AVAILABILITY_20_MEMBER);
    }

    protected void writeFormatDescriptor(GetDataAvailabilityResponse.FormatDescriptor formatDescriptor) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_20_FORMAT_DESCRIPTOR);
        this.writeProcedureDescriptionFormatDescriptor(formatDescriptor.getProcedureDescriptionFormatDescriptor());
        for (GetDataAvailabilityResponse.ObservationFormatDescriptor ofd : formatDescriptor.getObservationFormatDescriptors()) {
            this.writeObservationFormatDescriptor(ofd);
        }
        this.end(GetDataAvailabilityConstants.GDA_20_FORMAT_DESCRIPTOR);
    }

    protected void writeProcedureDescriptionFormatDescriptor(GetDataAvailabilityResponse.ProcedureDescriptionFormatDescriptor formatDescriptor) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_20_PROCEDURE_FORMAT_DESCRIPTOR);
        this.writeProcedureDescriptionFormat(formatDescriptor.getProcedureDescriptionFormat());
        this.end(GetDataAvailabilityConstants.GDA_20_PROCEDURE_FORMAT_DESCRIPTOR);
    }

    protected void writeObservationFormatDescriptor(GetDataAvailabilityResponse.ObservationFormatDescriptor formatDescriptor) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_20_OBSERVATION_FORMAT_DESCRIPTOR);
        this.writeResponseFormat(formatDescriptor.getResponseFormat());
        for (String observationType : formatDescriptor.getObservationTypes()) {
            this.writeObservationType(observationType);
        }
        this.end(GetDataAvailabilityConstants.GDA_20_OBSERVATION_FORMAT_DESCRIPTOR);
    }

    private void writeProcedureDescriptionFormat(String procedureDescriptionFormat) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_20_PROCEDURE_DESCRIPTION_FORMAT);
        this.chars(procedureDescriptionFormat);
        this.end(GetDataAvailabilityConstants.GDA_20_PROCEDURE_DESCRIPTION_FORMAT);
    }

    private void writeObservationType(String observationType) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_20_OBSERVATION_TYPE);
        this.chars(observationType);
        this.end(GetDataAvailabilityConstants.GDA_20_OBSERVATION_TYPE);
    }

    private void writeResponseFormat(String responseFormat) throws XMLStreamException {
        this.start(GetDataAvailabilityConstants.GDA_20_RESPONSE_FORMAT);
        this.chars(responseFormat);
        this.end(GetDataAvailabilityConstants.GDA_20_RESPONSE_FORMAT);
    }
}

