/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.Sos2StreamingConstants;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.SchemaAwareEncoder;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.XmlStreamWriter;

public class GetObservationResponseXmlStreamWriter
extends XmlStreamWriter<GetObservationResponse> {
    public GetObservationResponseXmlStreamWriter(EncodingContext context, OutputStream outputStream, GetObservationResponse element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    public void write() throws XMLStreamException, EncodingException {
        try {
            this.start();
            this.writeGetObservationResponseDoc();
            this.end();
            this.finish();
        }
        catch (XMLStreamException xmlse) {
            throw new EncodingException((Throwable)xmlse);
        }
    }

    private void writeGetObservationResponseDoc() throws XMLStreamException, EncodingException {
        this.start(Sos2StreamingConstants.GET_OBSERVATION_RESPONSE);
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.namespace("sos", "http://www.opengis.net/sos/2.0");
        GetObservationResponse response = (GetObservationResponse)this.getElement();
        ObservationEncoder<XmlObject, OmObservation> encoder = this.findObservationEncoder(response.getResponseFormat());
        this.schemaLocation(this.getSchemaLocation(encoder));
        EncodingContext ctx = this.getContext().with((Enum)XmlEncoderFlags.ENCODE_NAMESPACE, (Object)response.getResponseFormat()).with((Enum)XmlBeansEncodingFlags.DOCUMENT).with((Enum)StreamingEncoderFlags.EMBEDDED).without((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE).without((Enum)XmlBeansEncodingFlags.TYPE);
        try {
            ObservationStream stream = response.getObservationCollection();
            if (encoder.shouldObservationsWithSameXBeMerged()) {
                stream = stream.merge();
            }
            while (stream.hasNext()) {
                OmObservation o = (OmObservation)stream.next();
                if (o.getValue() instanceof ObservationStream) {
                    ObservationStream value = (ObservationStream)o.getValue();
                    if (encoder.supportsResultStreamingForMergedValues()) {
                        this.writeObservationData(ctx, o, encoder);
                        continue;
                    }
                    while (value.hasNext()) {
                        this.writeObservationData(ctx, (OmObservation)value.next(), encoder);
                    }
                    continue;
                }
                this.writeObservationData(ctx, o, encoder);
            }
        }
        catch (OwsExceptionReport owse) {
            throw new EncodingException((Throwable)owse);
        }
        this.end(Sos2StreamingConstants.GET_OBSERVATION_RESPONSE);
    }

    private void writeObservationData(EncodingContext ctx, OmObservation observation, ObservationEncoder<XmlObject, OmObservation> encoder) throws XMLStreamException, EncodingException {
        this.start(Sos2StreamingConstants.OBSERVATION_DATA);
        if (encoder instanceof StreamingEncoder) {
            ((StreamingEncoder)encoder).encode((Object)observation, this.getOutputStream(), ctx);
        } else {
            this.rawText(((XmlObject)encoder.encode((Object)observation, ctx)).xmlText(this.getXmlOptions().setSaveNoXmlDecl()));
        }
        this.end(Sos2StreamingConstants.OBSERVATION_DATA);
    }

    private Set<SchemaLocation> getSchemaLocation(ObservationEncoder<XmlObject, OmObservation> encoder) {
        return Stream.of(this.getEncoder().filter(e -> e instanceof SchemaAwareEncoder).map(e -> (SchemaAwareEncoder)e).map(SchemaAwareEncoder::getSchemaLocations).orElseGet(() -> Collections.singleton(Sos2Constants.SOS_GET_OBSERVATION_SCHEMA_LOCATION)), Optional.ofNullable(encoder).filter(e -> e instanceof SchemaAwareEncoder).map(e -> (SchemaAwareEncoder)e).map(SchemaAwareEncoder::getSchemaLocations).orElseGet(Collections::emptySet)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private ObservationEncoder<XmlObject, OmObservation> findObservationEncoder(String responseFormat) throws EncodingException {
        Optional encoder = this.tryGetEncoder((EncoderKey)new XmlEncoderKey(responseFormat, OmObservation.class));
        if (!encoder.isPresent()) {
            return null;
        }
        if (encoder.get() instanceof ObservationEncoder) {
            ObservationEncoder oe = (ObservationEncoder)encoder.get();
            return oe.isObservationAndMeasurmentV20Type() ? oe : null;
        }
        throw new EncodingException("Error while encoding response, encoder is not of type ObservationEncoder!", new Object[0]);
    }
}

