/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.html.HtmlEscapers;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.inspire.InspireCitation;
import org.n52.shetland.inspire.InspireConformity;
import org.n52.shetland.inspire.InspireConformityCitation;
import org.n52.shetland.inspire.InspireConstants;
import org.n52.shetland.inspire.InspireDateOf;
import org.n52.shetland.inspire.InspireDateOfCreation;
import org.n52.shetland.inspire.InspireDateOfLastRevision;
import org.n52.shetland.inspire.InspireDateOfPublication;
import org.n52.shetland.inspire.InspireKeyword;
import org.n52.shetland.inspire.InspireLanguageISO6392B;
import org.n52.shetland.inspire.InspireMandatoryKeyword;
import org.n52.shetland.inspire.InspireMandatoryKeywordValue;
import org.n52.shetland.inspire.InspireMetadataPointOfContact;
import org.n52.shetland.inspire.InspireObject;
import org.n52.shetland.inspire.InspireOriginatingControlledVocabulary;
import org.n52.shetland.inspire.InspireResourceLocator;
import org.n52.shetland.inspire.InspireSupportedCRS;
import org.n52.shetland.inspire.InspireSupportedLanguages;
import org.n52.shetland.inspire.InspireTemporalReference;
import org.n52.shetland.inspire.InspireUniqueResourceIdentifier;
import org.n52.shetland.inspire.dls.FullInspireExtendedCapabilities;
import org.n52.shetland.inspire.dls.InspireCapabilities;
import org.n52.shetland.inspire.dls.MinimalInspireExtendedCapabilities;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.gml.time.TimePosition;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.XmlStreamWriter;

public class InspireXmlStreamWriter
extends XmlStreamWriter<InspireObject>
implements InspireConstants {
    public InspireXmlStreamWriter(EncodingContext context, OutputStream outputStream, InspireObject element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    public void write() throws XMLStreamException, EncodingException {
        if (this.getElement() instanceof FullInspireExtendedCapabilities) {
            this.writeFullInspireExtendedCapabilities((FullInspireExtendedCapabilities)this.getElement());
        } else if (this.getElement() instanceof MinimalInspireExtendedCapabilities) {
            this.writeMinimlaInspireExtendedCapabilities((MinimalInspireExtendedCapabilities)this.getElement());
        } else if (this.getElement() instanceof InspireSupportedLanguages) {
            this.writeSupportedLanguages((InspireSupportedLanguages)this.getElement(), true);
        } else if (this.getElement() instanceof InspireSupportedCRS) {
            this.writeSupportedCRS((InspireSupportedCRS)this.getElement(), true);
        }
        this.finish();
    }

    private void writeMinimlaInspireExtendedCapabilities(MinimalInspireExtendedCapabilities minimalInspireExtendedCapabilities) throws XMLStreamException {
        this.start(QN_EXTENDED_CAPABILITIES);
        this.writeInspireCommonNamespaces(true);
        this.writeInspireDLSNamespaces();
        this.writeMetadataUrl(minimalInspireExtendedCapabilities.getMetadataUrl());
        this.writeSupportedLanguages(minimalInspireExtendedCapabilities.getSupportedLanguages(), false);
        this.writeResponseLanguage(minimalInspireExtendedCapabilities.getResponseLanguage());
        for (InspireUniqueResourceIdentifier inspireUniqueResourceIdentifier : minimalInspireExtendedCapabilities.getSpatialDataSetIdentifier()) {
            this.writeSpatialDataSetIdentifier(inspireUniqueResourceIdentifier);
        }
        this.writeSupportedCRS(minimalInspireExtendedCapabilities.getSupportedCRS(), false);
        this.end(QN_EXTENDED_CAPABILITIES);
    }

    private void writeFullInspireExtendedCapabilities(FullInspireExtendedCapabilities fullInspireExtendedCapabilities) throws XMLStreamException {
        this.start(QN_EXTENDED_CAPABILITIES);
        this.writeInspireCommonNamespaces(true);
        this.writeInspireDLSNamespaces();
        for (InspireResourceLocator resourceLocator : fullInspireExtendedCapabilities.getResourceLocator()) {
            this.writeResourceLocator(resourceLocator);
        }
        this.writeResourceType(fullInspireExtendedCapabilities.getResourceType());
        this.writeTemporalReference(fullInspireExtendedCapabilities.getTemporalReferences());
        for (InspireConformity conformity : fullInspireExtendedCapabilities.getConformity()) {
            this.writeConformity(conformity);
        }
        for (InspireMetadataPointOfContact metadataPointOfContact : fullInspireExtendedCapabilities.getMetadataPointOfContacts()) {
            this.writeMetadataPointOfContact(metadataPointOfContact);
        }
        this.writeMetadataDate(fullInspireExtendedCapabilities.getMetadataDate());
        this.writeSpatialDataServiceType(fullInspireExtendedCapabilities.getSpatialDataServiceType());
        for (InspireMandatoryKeyword mandatoryKeyword : fullInspireExtendedCapabilities.getMandatoryKeywords()) {
            this.writeMandatoryKeyword(mandatoryKeyword);
        }
        if (fullInspireExtendedCapabilities.isSetKeywords()) {
            for (InspireKeyword keyword : fullInspireExtendedCapabilities.getKeywords()) {
                this.writeKeyword(keyword);
            }
        }
        this.writeSupportedLanguages(fullInspireExtendedCapabilities.getSupportedLanguages(), false);
        this.writeResponseLanguage(fullInspireExtendedCapabilities.getResponseLanguage());
        if (fullInspireExtendedCapabilities.isSetMetadataUrl()) {
            this.writeMetadataUrl(fullInspireExtendedCapabilities.getMetadataUrl());
        }
        for (InspireUniqueResourceIdentifier inspireUniqueResourceIdentifier : fullInspireExtendedCapabilities.getSpatialDataSetIdentifier()) {
            this.writeSpatialDataSetIdentifier(inspireUniqueResourceIdentifier);
        }
        this.writeSupportedCRS(fullInspireExtendedCapabilities.getSupportedCRS(), false);
        this.end(QN_EXTENDED_CAPABILITIES);
    }

    private void writeCitationContent(InspireCitation citation) throws XMLStreamException {
        this.writeTitle(citation.getTitle());
        this.writeDateOf(citation.getDateOf());
        if (citation.isSetUrls()) {
            for (String url : citation.getUrls()) {
                this.writeURI(url);
            }
        }
        if (citation.isSetResourceLocators()) {
            for (InspireResourceLocator resourceLocator : citation.getResourceLocator()) {
                this.writeResourceLocator(resourceLocator);
            }
        }
    }

    private void writeCode(String code) throws XMLStreamException {
        this.start(QN_CODE);
        this.chars(code);
        this.endInline(QN_CODE);
    }

    private void writeConformity(InspireConformity conformity) throws XMLStreamException {
        this.start(QN_CONFORMITY);
        this.writeSpecification(conformity.getInspireSpecification());
        this.writeDegree(conformity.getInspireDegreeOfConformity());
        this.end(QN_CONFORMITY);
    }

    private void writeDefaultLanguage(InspireLanguageISO6392B defaultLanguage) throws XMLStreamException {
        this.start(QN_DEFAULT_LANGUAGE);
        this.writeLanguage(defaultLanguage);
        this.end(QN_DEFAULT_LANGUAGE);
    }

    private void writeDegree(InspireConformity.InspireDegreeOfConformity inspireDegreeOfConformity) throws XMLStreamException {
        this.start(QN_DEGREE);
        this.chars(inspireDegreeOfConformity.toString());
        this.endInline(QN_DEGREE);
    }

    private void writeDateOf(InspireDateOf dateOf) throws XMLStreamException {
        if (dateOf instanceof InspireDateOfPublication) {
            this.writeDateOfPublication((InspireDateOfPublication)dateOf);
        } else if (dateOf instanceof InspireDateOfCreation) {
            this.writeDateOfCreation((InspireDateOfCreation)dateOf);
        } else if (dateOf instanceof InspireDateOfLastRevision) {
            this.writeDateOfLastRevision((InspireDateOfLastRevision)dateOf);
        }
    }

    private void writeDateOfPublication(InspireDateOfPublication dateOf) throws XMLStreamException {
        this.start(QN_DATE_OF_PUBLICATION);
        this.time((TimeInstant)dateOf);
        this.endInline(QN_DATE_OF_PUBLICATION);
    }

    private void writeDateOfCreation(InspireDateOfCreation dateOf) throws XMLStreamException {
        this.start(QN_DATE_OF_CREATION);
        this.time((TimeInstant)dateOf);
        this.endInline(QN_DATE_OF_CREATION);
    }

    private void writeDateOfLastRevision(InspireDateOfLastRevision dateOf) throws XMLStreamException {
        this.start(QN_DATE_OF_LAST_REVISION);
        this.time((TimeInstant)dateOf);
        this.endInline(QN_DATE_OF_LAST_REVISION);
    }

    private void writeEmailAddress(String emailAddress) throws XMLStreamException {
        this.start(QN_EMAIL_ADDRESS);
        this.chars(emailAddress);
        this.endInline(QN_EMAIL_ADDRESS);
    }

    private void writeEndDate(TimePosition time) throws XMLStreamException {
        this.start(QN_END_DATE);
        this.time(time);
        this.endInline(QN_END_DATE);
    }

    private void writeIndividualDate(TimeInstant time) throws XMLStreamException {
        this.start(QN_INDIVIDUAL_DATE);
        this.time(time);
        this.endInline(QN_INDIVIDUAL_DATE);
    }

    private void writeInspireDLSNamespaces() throws XMLStreamException {
        this.namespace("inspire_dls", "http://inspire.ec.europa.eu/schemas/inspire_dls/1.0");
    }

    private void writeInspireCommonNamespaces(boolean root) throws XMLStreamException {
        if (root) {
            this.namespace("inspire_common", "http://inspire.ec.europa.eu/schemas/common/1.0");
        }
    }

    private void writeIntervalOfTime(TimePeriod time) throws XMLStreamException {
        this.start(QN_INTERVAL_OF_DATES);
        this.writeStartingDate(time.getStartTimePosition());
        this.writeEndDate(time.getEndTimePosition());
        this.end(QN_INTERVAL_OF_DATES);
    }

    private void writeKeyword(InspireKeyword keyword) throws XMLStreamException {
        if (keyword.isSetOriginatingControlledVocabulary()) {
            this.writeOriginatingControlledVocabulary(keyword.getOriginatingControlledVocabulary());
        }
        this.start(QN_KEYWORD);
        this.writeKeywordValue(keyword.getKeywordValue());
        this.end(QN_KEYWORD);
    }

    private void writeKeywordValue(String keywordValue) throws XMLStreamException {
        this.start(QN_KEYWORD_VALUE);
        this.chars(keywordValue);
        this.endInline(QN_KEYWORD_VALUE);
    }

    private void writeKeywordValue(InspireMandatoryKeywordValue keywordValue) throws XMLStreamException {
        this.writeKeywordValue(keywordValue.toString());
    }

    private void writeLanguage(InspireLanguageISO6392B language) throws XMLStreamException {
        this.start(QN_LANGUAGE);
        this.chars(language.value());
        this.endInline(QN_LANGUAGE);
    }

    private void writeMandatoryKeyword(InspireMandatoryKeyword mandatoryKeyword) throws XMLStreamException {
        this.start(QN_MANDATORY_KEYWORD);
        this.writeKeywordValue(mandatoryKeyword.getKeywordValue());
        this.end(QN_MANDATORY_KEYWORD);
    }

    private void writeMediaType(MediaType mediaType) throws XMLStreamException {
        this.start(QN_MEDIA_TYPE);
        this.chars(mediaType.toString());
        this.endInline(QN_MEDIA_TYPE);
    }

    private void writeMetadataDate(TimeInstant metadataDate) throws XMLStreamException {
        this.start(QN_METADATA_DATE);
        this.time(metadataDate);
        this.endInline(QN_METADATA_DATE);
    }

    private void writeMetadataPointOfContact(InspireMetadataPointOfContact metadataPointOfContact) throws XMLStreamException {
        this.start(QN_METADATA_POINT_OF_CONTACT);
        this.writeOrganisationName(metadataPointOfContact.getOrganisationName());
        this.writeEmailAddress(metadataPointOfContact.getEmailAddress());
        this.end(QN_METADATA_POINT_OF_CONTACT);
    }

    private void writeMetadataUrl(InspireResourceLocator metadataUrl) throws XMLStreamException {
        this.start(QN_METADATA_URL);
        this.writeResourceLocatorContent(metadataUrl);
        this.end(QN_METADATA_URL);
    }

    private void writeNamespace(String namespace) throws XMLStreamException {
        this.start(QN_NAMESPACE);
        this.chars(namespace);
        this.end(QN_NAMESPACE);
    }

    private void writeOriginatingControlledVocabulary(InspireOriginatingControlledVocabulary originatingControlledVocabulary) throws XMLStreamException {
        this.start(QN_ORIGINATING_CONTROLLED_VOCABULARY);
        this.writeCitationContent((InspireCitation)originatingControlledVocabulary);
        this.end(QN_ORIGINATING_CONTROLLED_VOCABULARY);
    }

    private void writeOrganisationName(String organisationName) throws XMLStreamException {
        this.start(QN_ORGANISATION_NAME);
        this.chars(organisationName);
        this.endInline(QN_SPATIAL_DATA_SERVICE_TYPE);
    }

    private void writeResponseLanguage(InspireLanguageISO6392B responseLanguage) throws XMLStreamException {
        this.start(QN_RESPONSE_LANGUAGE);
        this.writeLanguage(responseLanguage);
        this.end(QN_RESPONSE_LANGUAGE);
    }

    private void writeResourceLocatorContent(InspireResourceLocator resourceLocator) throws XMLStreamException {
        this.writeUrl(resourceLocator.getURL());
        if (resourceLocator.isSetMediaTypes()) {
            for (MediaType mediaType : resourceLocator.getMediaTypes()) {
                this.writeMediaType(mediaType);
            }
        }
    }

    private void writeResourceLocator(InspireResourceLocator resourceLocator) throws XMLStreamException {
        this.start(QN_RESOURCE_LOCATOR);
        this.writeResourceLocatorContent(resourceLocator);
        this.end(QN_RESOURCE_LOCATOR);
    }

    private void writeResourceType(InspireCapabilities.InspireServiceSpatialDataResourceType resourceType) throws XMLStreamException {
        this.start(QN_RESOURCE_TYPE);
        this.chars(resourceType.toString());
        this.endInline(QN_RESOURCE_TYPE);
    }

    private void writeSupportedLanguages(InspireSupportedLanguages supportedLanguages, boolean root) throws XMLStreamException {
        this.start(QN_SUPPORTED_LANGUAGES);
        this.writeInspireCommonNamespaces(root);
        this.writeDefaultLanguage(supportedLanguages.getDefaultLanguage());
        if (supportedLanguages.isSetSupportedLanguages()) {
            for (InspireLanguageISO6392B supportedLanguage : supportedLanguages.getSupportedLanguages()) {
                this.writeSupportedLanguage(supportedLanguage);
            }
        }
        this.end(QN_SUPPORTED_LANGUAGES);
    }

    private void writeSpatialDataServiceType(InspireCapabilities.InspireSpatialDataServiceType spatialDataServiceType) throws XMLStreamException {
        this.start(QN_SPATIAL_DATA_SERVICE_TYPE);
        this.chars(spatialDataServiceType.toString());
        this.endInline(QN_SPATIAL_DATA_SERVICE_TYPE);
    }

    private void writeSpatialDataSetIdentifier(InspireUniqueResourceIdentifier inspireUniqueResourceIdentifier) throws XMLStreamException {
        this.start(QN_SPATIAL_DATASET_IDENTIFIER);
        this.writeUniqueResourceIdentifierContent(inspireUniqueResourceIdentifier);
        this.endInline(QN_SPATIAL_DATASET_IDENTIFIER);
    }

    private void writeSpecification(InspireConformityCitation inspireSpecification) throws XMLStreamException {
        this.start(QN_SPECIFICATION);
        this.writeCitationContent((InspireCitation)inspireSpecification);
        this.end(QN_SPECIFICATION);
    }

    private void writeStartingDate(TimePosition time) throws XMLStreamException {
        this.start(QN_STARTING_DATE);
        this.time(time);
        this.endInline(QN_STARTING_DATE);
    }

    private void writeSupportedLanguage(InspireLanguageISO6392B supportedLanguage) throws XMLStreamException {
        this.start(QN_SUPPORTED_LANGUAGE);
        this.writeLanguage(supportedLanguage);
        this.end(QN_SUPPORTED_LANGUAGE);
    }

    private void writeTemporalExtent(Time temporalExtent) throws XMLStreamException {
        this.start(QN_TEMPORAL_EXTENT);
        if (temporalExtent instanceof TimeInstant) {
            this.writeIndividualDate((TimeInstant)temporalExtent);
        } else if (temporalExtent instanceof TimePeriod) {
            this.writeIntervalOfTime((TimePeriod)temporalExtent);
        }
        this.end(QN_TEMPORAL_EXTENT);
    }

    private void writeTemporalReference(InspireTemporalReference temporalReference) throws XMLStreamException {
        if (!(temporalReference.isSetDateOfCreation() || temporalReference.isSetDateOfLastRevision() || temporalReference.isSetDatesOfPublication() || temporalReference.isSetTemporalExtents())) {
            this.empty(QN_TEMPORAL_REFERENCE);
        } else {
            this.start(QN_TEMPORAL_REFERENCE);
            if (temporalReference.isSetDateOfCreation()) {
                this.writeDateOfCreation(temporalReference.getDateOfCreation());
            }
            if (temporalReference.isSetDateOfLastRevision()) {
                this.writeDateOfLastRevision(temporalReference.getDateOfLastRevision());
            }
            if (temporalReference.isSetDatesOfPublication()) {
                for (InspireDateOfPublication dateOfPublication : temporalReference.getDatesOfPublication()) {
                    this.writeDateOfPublication(dateOfPublication);
                }
            }
            if (temporalReference.isSetTemporalExtents()) {
                for (Time temporalExtent : temporalReference.getTemporalExtents()) {
                    this.writeTemporalExtent(temporalExtent);
                }
            }
            this.end(QN_TEMPORAL_REFERENCE);
        }
    }

    private void writeTemporalReference(List<InspireTemporalReference> temporalReferences) throws XMLStreamException {
        if (CollectionHelper.isNotEmpty(temporalReferences)) {
            for (InspireTemporalReference temporalReference : temporalReferences) {
                this.writeTemporalReference(temporalReference);
            }
        } else {
            this.empty(QN_TEMPORAL_REFERENCE);
        }
    }

    private void writeTitle(String title) throws XMLStreamException {
        this.start(QN_TITLE);
        this.chars(title);
        this.endInline(QN_TITLE);
    }

    private void writeUniqueResourceIdentifierContent(InspireUniqueResourceIdentifier uniqueResourceIdentifier) throws XMLStreamException {
        this.writeCode(uniqueResourceIdentifier.getCode());
        if (uniqueResourceIdentifier.isSetNamespace()) {
            this.writeNamespace(uniqueResourceIdentifier.getNamespace());
        }
    }

    private void writeURI(String url) throws XMLStreamException {
        this.start(QN_URI);
        this.chars(HtmlEscapers.htmlEscaper().escape(url));
        this.endInline(QN_URI);
    }

    private void writeUrl(String url) throws XMLStreamException {
        this.start(QN_URL);
        this.chars(HtmlEscapers.htmlEscaper().escape(url));
        this.endInline(QN_URL);
    }

    private void writeSupportedCRS(InspireSupportedCRS supportedCRSes, boolean root) throws XMLStreamException {
        this.start(QN_SUPPORTED_CRS);
        if (root) {
            this.writeInspireDLSNamespaces();
        }
        this.writeDefaultCRS(supportedCRSes.getDefaultCRS());
        if (supportedCRSes.isSetSupportedCRSs()) {
            for (String supportedCRS : supportedCRSes.getOtherCRS()) {
                this.writeOtherCRS(supportedCRS);
            }
        }
        this.end(QN_SUPPORTED_CRS);
    }

    private void writeDefaultCRS(String crs) throws XMLStreamException {
        this.start(QN_DEFAULT_CRS);
        this.chars(crs);
        this.endInline(QN_DEFAULT_CRS);
    }

    private void writeOtherCRS(String crs) throws XMLStreamException {
        this.start(QN_OTHER_CRS);
        this.chars(crs);
        this.endInline(QN_OTHER_CRS);
    }

    private void writeCRS(String crs) throws XMLStreamException {
        this.start(QN_CRS);
        this.chars(crs);
        this.endInline(QN_CRS);
    }
}

