/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.sos.ro.OfferingContext;
import org.n52.shetland.ogc.sos.ro.RelatedOfferingConstants;
import org.n52.shetland.ogc.sos.ro.RelatedOfferings;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.XmlStreamWriter;

public class RelatedOfferingXmlStreamWriter
extends XmlStreamWriter<RelatedOfferings> {
    public RelatedOfferingXmlStreamWriter(EncodingContext context, OutputStream outputStream, RelatedOfferings element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    public void write() throws XMLStreamException, EncodingException {
        this.start();
        this.writeRelatedOfferingsDoc();
        this.end();
        this.finish();
    }

    private void writeRelatedOfferingsDoc() throws XMLStreamException {
        this.start(RelatedOfferingConstants.QN_RO_RELATED_OFFERINGS);
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.namespace("ro", "http://www.opengis.net/sosro/1.0");
        this.namespace("gml", "http://www.opengis.net/gml/3.2");
        this.addXlinkHrefAttr("relatedOfferings");
        this.addXlinkTitleAttr("relatedOfferings");
        for (OfferingContext offeringContext : ((RelatedOfferings)this.getElement()).getValue()) {
            this.start(RelatedOfferingConstants.QN_RO_RELATED_OFFERING);
            this.writeOfferingContext(offeringContext);
            this.end(RelatedOfferingConstants.QN_RO_RELATED_OFFERING);
        }
        this.end(RelatedOfferingConstants.QN_RO_RELATED_OFFERINGS);
    }

    private void writeOfferingContext(OfferingContext offeringContext) throws XMLStreamException {
        this.start(RelatedOfferingConstants.QN_RO_OFFERING_CONTEXT);
        this.writeRole(offeringContext.getRole());
        this.writeRelatedOffering(offeringContext.getRelatedOffering());
        this.end(RelatedOfferingConstants.QN_RO_OFFERING_CONTEXT);
    }

    private void writeRole(ReferenceType role) throws XMLStreamException {
        this.empty(RelatedOfferingConstants.QN_RO_ROLE);
        this.addXlinkHrefAttr(role.getHref());
    }

    private void writeRelatedOffering(ReferenceType relatedOffering) throws XMLStreamException {
        this.empty(RelatedOfferingConstants.QN_RO_RELATED_OFFERING);
        this.addXlinkHrefAttr(relatedOffering.getHref());
        if (relatedOffering.isSetTitle()) {
            this.addXlinkTitleAttr(relatedOffering.getTitle());
        } else {
            this.addXlinkTitleAttr(this.getTitleFromHref(relatedOffering.getHref()));
        }
    }

    private String getTitleFromHref(String href) {
        String title = href;
        if (title.startsWith("http")) {
            title = title.substring(title.lastIndexOf(47) + 1, title.length());
        } else if (title.startsWith("urn")) {
            title = title.substring(title.lastIndexOf(58) + 1, title.length());
        }
        if (title.contains("#")) {
            title = title.substring(title.lastIndexOf(35) + 1, title.length());
        }
        return title;
    }
}

