/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.soap.SoapConstants;
import org.n52.shetland.w3c.soap.SoapFault;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.OperationResponseEncoderKey;
import org.n52.svalbard.encode.SchemaAwareEncoder;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.write.XmlStreamWriter;

public class Soap12XmlStreamWriter
extends XmlStreamWriter<SoapResponse> {
    public Soap12XmlStreamWriter(EncodingContext context, OutputStream outputStream, SoapResponse element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    public void write() throws EncodingException, XMLStreamException {
        this.start();
        this.writeSoapEnvelope();
        this.end();
        this.finish();
    }

    protected void writeSoapEnvelope() throws XMLStreamException, EncodingException {
        this.start(SoapConstants.SOAP_12_ENVELOPE);
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.namespace("soap", "http://www.w3.org/2003/05/soap-envelope");
        this.schemaLocation(this.getSchemaLocation());
        this.writeSoapBody();
        this.end(SoapConstants.SOAP_12_ENVELOPE);
    }

    protected Set<SchemaLocation> getSchemaLocation() throws EncodingException, XMLStreamException {
        Encoder<Object, OwsServiceResponse> encoder;
        SoapResponse response = (SoapResponse)this.getElement();
        HashSet schemaLocations = Sets.newHashSet();
        schemaLocations.add(SoapConstants.SOAP_12_SCHEMA_LOCATION);
        if (response.isSetBodyContent() && (encoder = this.getEncoder(response.getBodyContent())) != null && encoder instanceof SchemaAwareEncoder) {
            schemaLocations.addAll(((SchemaAwareEncoder)encoder).getSchemaLocations());
        }
        return schemaLocations;
    }

    protected void writeSoapBody() throws XMLStreamException, EncodingException {
        this.start(SoapConstants.SOAP_12_BODY);
        SoapResponse response = (SoapResponse)this.getElement();
        if (response != null) {
            if (response.isSetSoapFault()) {
                this.writeSoapFault(response.getSoapFault());
            } else if (response.hasException()) {
                this.writeSoapFaultFromException(response.getException());
            } else if (response.isSetBodyContent()) {
                this.writeBodyContent(response.getBodyContent());
            }
        }
        this.end(SoapConstants.SOAP_12_BODY);
    }

    protected void writeBodyContent(OwsServiceResponse bodyResponse) throws XMLStreamException, EncodingException {
        Encoder encoder = this.getEncoder((EncoderKey)new OperationResponseEncoderKey(new OwsOperationKey((OwsServiceCommunicationObject)bodyResponse), MediaTypes.APPLICATION_XML));
        if (encoder instanceof StreamingEncoder) {
            EncodingContext ctx = this.getContext().with((Enum)XmlBeansEncodingFlags.DOCUMENT).without((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE).without((Enum)XmlBeansEncodingFlags.TYPE).with((Enum)StreamingEncoderFlags.EMBEDDED, (Object)true);
            ((StreamingEncoder)encoder).encode((Object)bodyResponse, this.getOutputStream(), ctx);
        } else {
            String soapBodyContent = ((XmlObject)encoder.encode((Object)bodyResponse)).xmlText(this.getXmlOptions());
            this.rawText(this.stripXmlDeclaration(soapBodyContent));
        }
    }

    protected void writeSoapFault(SoapFault fault) throws EncodingException, XMLStreamException {
        Encoder encoder = this.getEncoder("http://www.w3.org/2003/05/soap-envelope", fault);
        String soapFault = ((XmlObject)encoder.encode((Object)fault)).xmlText(this.getXmlOptions());
        this.rawText(this.stripXmlDeclaration(soapFault));
    }

    protected void writeSoapFaultFromException(OwsExceptionReport exception) throws EncodingException, XMLStreamException {
        Encoder encoder = this.getEncoder("http://www.w3.org/2003/05/soap-envelope", exception);
        String soapFault = ((XmlObject)encoder.encode((Object)exception)).xmlText(this.getXmlOptions());
        this.rawText(this.stripXmlDeclaration(soapFault));
    }

    protected Encoder<Object, OwsServiceResponse> getEncoder(OwsServiceResponse abstractServiceResponse) throws NoEncoderForKeyException {
        return this.getEncoder((EncoderKey)new OperationResponseEncoderKey(new OwsOperationKey((OwsServiceCommunicationObject)abstractServiceResponse), MediaTypes.APPLICATION_XML));
    }

    private String stripXmlDeclaration(String soapFault) {
        if (soapFault.startsWith("<?xml")) {
            return soapFault.substring(soapFault.indexOf(62));
        }
        return soapFault;
    }
}

