/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.base.Strings;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservableProperty;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.StreamingValue;
import org.n52.shetland.ogc.om.TimeValuePair;
import org.n52.shetland.ogc.om.series.wml.MeasurementTimeseriesMetadata;
import org.n52.shetland.ogc.om.series.wml.WaterMLConstants;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.ProfileLevel;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.write.AbstractOmV20XmlStreamWriter;

public class WmlTVPEncoderv20XmlStreamWriter
extends AbstractOmV20XmlStreamWriter {
    public WmlTVPEncoderv20XmlStreamWriter(EncodingContext context, OutputStream outputStream, OmObservation element) throws XMLStreamException {
        super(context, outputStream, element);
    }

    @Override
    protected void writeResult() throws XMLStreamException, EncodingException {
        this.start(OmConstants.QN_OM_20_RESULT);
        this.namespace("wml2", "http://www.opengis.net/waterml/2.0");
        this.start(WaterMLConstants.QN_MEASUREMENT_TIMESERIES);
        OmObservation observation = (OmObservation)this.getElement();
        this.attr(GmlConstants.QN_ID_32, "timeseries." + observation.getObservationID());
        this.writeMeasurementTimeseriesMetadata(observation);
        if (observation.getValue() instanceof SingleObservationValue) {
            SingleObservationValue observationValue = (SingleObservationValue)observation.getValue();
            this.writeDefaultPointMetadata((ObservationValue<?>)observationValue, observationValue.getValue().getUnit());
            String time = this.getTimeString(observationValue.getPhenomenonTime());
            this.writePoint(time, this.getValue(observation.getValue().getValue()));
            this.close();
        } else if (observation.getValue() instanceof MultiObservationValues) {
            MultiObservationValues observationValue = (MultiObservationValues)observation.getValue();
            this.writeDefaultPointMetadata((ObservationValue<?>)observationValue, observationValue.getValue().getUnit());
            TVPValue tvpValue = (TVPValue)observationValue.getValue();
            List timeValuePairs = tvpValue.getValue();
            for (TimeValuePair timeValuePair : timeValuePairs) {
                if (timeValuePair == null) continue;
                this.writePoint(this.getTimeString(timeValuePair.getTime()), this.getValue(timeValuePair.getValue()));
            }
            this.close();
        } else if (observation.getValue() instanceof StreamingValue) {
            StreamingValue observationValue = (StreamingValue)observation.getValue();
            if (observationValue.isSetUnit()) {
                this.writeDefaultPointMetadata((ObservationValue<?>)observationValue, observationValue.getUnit());
            } else if (observation.getObservationConstellation().getObservableProperty() instanceof OmObservableProperty && ((OmObservableProperty)observation.getObservationConstellation().getObservableProperty()).isSetUnit()) {
                this.writeDefaultPointMetadata((ObservationValue<?>)observationValue, ((OmObservableProperty)observation.getObservationConstellation().getObservableProperty()).getUnit());
            } else {
                this.writeDefaultPointMetadata((ObservationValue<?>)observationValue, null);
            }
            try {
                while (observationValue.hasNext()) {
                    TimeValuePair timeValuePair = observationValue.nextValue();
                    if (timeValuePair == null) continue;
                    this.writePoint(this.getTimeString(timeValuePair.getTime()), this.getValue(timeValuePair.getValue()));
                }
            }
            catch (OwsExceptionReport | DateTimeFormatException e) {
                throw new EncodingException(e);
            }
            this.close();
        } else {
            super.writeResult();
        }
    }

    @Override
    protected void writeAddtitionalNamespaces() throws XMLStreamException {
        this.namespace("wml2", "http://www.opengis.net/waterml/2.0");
    }

    @Override
    protected void checkAndWriteIdentifier() throws EncodingException, XMLStreamException {
        if (((OmObservation)this.getElement()).getObservationConstellation().isSetIdentifier()) {
            this.writeIdentifier(((OmObservation)this.getElement()).getObservationConstellation().getIdentifierCodeWithAuthority());
        } else {
            super.checkAndWriteIdentifier();
        }
    }

    @Override
    protected void checkAndWriteName() throws EncodingException, XMLStreamException {
        if (((OmObservation)this.getElement()).getObservationConstellation().isSetName()) {
            for (CodeType name : ((OmObservation)this.getElement()).getObservationConstellation().getName()) {
                this.writeName(name);
            }
        } else {
            super.checkAndWriteName();
        }
    }

    @Override
    protected void checkAndWriteDescription() throws XMLStreamException {
        if (((OmObservation)this.getElement()).getObservationConstellation().isSetDescription()) {
            this.writeDescription(((OmObservation)this.getElement()).getObservationConstellation().getDescription());
        } else {
            super.checkAndWriteDescription();
        }
    }

    private void close() throws XMLStreamException {
        this.end(WaterMLConstants.QN_MEASUREMENT_TIMESERIES);
        this.end(OmConstants.QN_OM_20_RESULT);
    }

    private void writeMeasurementTimeseriesMetadata(OmObservation o) throws XMLStreamException {
        this.start(WaterMLConstants.QN_METADATA);
        this.start(WaterMLConstants.QN_MEASUREMENT_TIMESERIES_METADATA);
        this.empty(WaterMLConstants.QN_TEMPORAL_EXTENT);
        this.addXlinkHrefAttr("#" + o.getPhenomenonTime().getGmlId());
        if (o.isSetValue() && o.getValue().isSetMetadata() && o.getValue().getMetadata().isSetTimeseriesMetadata() && o.getValue().getMetadata().getTimeseriesmetadata() instanceof MeasurementTimeseriesMetadata) {
            this.start(WaterMLConstants.QN_CUMULATIVE);
            this.chars(Boolean.toString(((MeasurementTimeseriesMetadata)o.getValue().getMetadata().getTimeseriesmetadata()).isCumulative()));
            this.endInline(WaterMLConstants.QN_CUMULATIVE);
        }
        this.end(WaterMLConstants.QN_MEASUREMENT_TIMESERIES_METADATA);
        this.end(WaterMLConstants.QN_METADATA);
    }

    private void writeDefaultPointMetadata(ObservationValue<?> value, String unit) throws XMLStreamException {
        this.start(WaterMLConstants.QN_DEFAULT_POINT_METADATA);
        this.start(WaterMLConstants.QN_DEFAULT_TVP_MEASUREMENT_METADATA);
        this.writeUOM(unit);
        this.writeInterpolationType(value);
        this.end(WaterMLConstants.QN_DEFAULT_TVP_MEASUREMENT_METADATA);
        this.end(WaterMLConstants.QN_DEFAULT_POINT_METADATA);
    }

    private void writeUOM(String code) throws XMLStreamException {
        if (!Strings.isNullOrEmpty((String)code)) {
            this.empty(WaterMLConstants.UOM);
            this.attr("code", code);
        }
    }

    private void writeInterpolationType(ObservationValue<?> value) throws XMLStreamException {
        this.empty(WaterMLConstants.QN_INTERPOLATION_TYPE);
        if (value != null && value.isSetMetadata() && value.getDefaultPointMetadata().isSetDefaultTVPMeasurementMetadata() && value.getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().isSetInterpolationType()) {
            WaterMLConstants.InterpolationType interpolationtype = value.getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().getInterpolationtype();
            this.addXlinkHrefAttr(interpolationtype.getIdentifier());
            this.addXlinkTitleAttr(interpolationtype.getTitle());
        } else {
            this.addXlinkHrefAttr("http://www.opengis.net/def/timeseriesType/WaterML/2.0/continuous");
            this.addXlinkTitleAttr("Instantaneous");
        }
    }

    private String getValue(Value<?> value) {
        if (value != null && value.isSetValue()) {
            if (value instanceof QuantityValue) {
                QuantityValue quantityValue = (QuantityValue)value;
                return Double.toString(quantityValue.getValue());
            }
            if (value instanceof ProfileValue) {
                ProfileValue gwglcValue = (ProfileValue)value;
                if (gwglcValue.isSetValue()) {
                    return this.getValue(((ProfileLevel)gwglcValue.getValue().iterator().next()).getSimpleValue());
                }
            } else {
                if (value instanceof CountValue) {
                    CountValue countValue = (CountValue)value;
                    return Integer.toString(countValue.getValue());
                }
                if (value instanceof TextValue) {
                    TextValue textValue = (TextValue)value;
                    String nonXmlEscapedText = textValue.getValue();
                    return StringEscapeUtils.escapeXml((String)nonXmlEscapedText);
                }
            }
        }
        return null;
    }

    private void writePoint(String time, String value) throws XMLStreamException {
        if (!Strings.isNullOrEmpty((String)time)) {
            this.start(WaterMLConstants.QN_POINT);
            this.writeMeasurementTVP(time, value);
            this.end(WaterMLConstants.QN_POINT);
        }
    }

    private void writeMeasurementTVP(String time, String value) throws XMLStreamException {
        this.start(WaterMLConstants.QN_MEASUREMENT_TVP);
        this.writeTime(time);
        this.writeValue(value);
        this.end(WaterMLConstants.QN_MEASUREMENT_TVP);
    }

    private void writeTime(String time) throws XMLStreamException {
        this.start(WaterMLConstants.QN_TIME);
        this.chars(time);
        this.endInline(WaterMLConstants.QN_TIME);
    }

    private void writeValue(String value) throws XMLStreamException {
        if (!Strings.isNullOrEmpty((String)value)) {
            this.start(WaterMLConstants.QN_VALUE);
            this.chars(value);
            this.endInline(WaterMLConstants.QN_VALUE);
        } else {
            this.empty(WaterMLConstants.QN_VALUE);
            this.attr(W3CConstants.QN_XSI_NIL, "true");
            this.writeValueMetadata();
        }
    }

    private void writeValueMetadata() throws XMLStreamException {
        this.start(WaterMLConstants.QN_METADATA);
        this.start(WaterMLConstants.QN_TVP_MEASUREMENT_METADATA);
        this.empty(WaterMLConstants.QN_NIL_REASON);
        this.addXlinkHrefAttr("missing");
        this.endInline(WaterMLConstants.QN_TVP_MEASUREMENT_METADATA);
        this.endInline(WaterMLConstants.QN_METADATA);
    }

    @Override
    protected Optional<String> getDefaultFeatureEncodingNamespace() {
        return Optional.of("http://www.opengis.net/waterml/2.0");
    }
}

