/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write;

import com.google.common.base.Strings;
import com.google.common.xml.XmlEscapers;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.joda.time.DateTime;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePosition;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncoderRepository;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.XmlStreamEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.util.N52XmlHelper;
import org.n52.svalbard.write.util.ExtendedXMLStreamWriter;
import org.n52.svalbard.write.util.IndentingXMLStreamWriter;

public abstract class XmlStreamWriter<S> {
    protected static final String XML_FRAGMENT = "xml-fragment";
    private static final String OUTPUT_PROPERTY_ESCAPE_CHARACTERS = "escapeCharacters";
    private static final int INDENTATION = 2;
    private EncodingContext context;
    private final S element;
    private final EncoderRepository encoderRepository;
    private final OutputStream outputStream;
    private final Supplier<XmlOptions> xmlOptions;
    private final ExtendedXMLStreamWriter writer;
    private final String xmlVersion;
    private final String xmlEncoding;
    private final boolean close;
    private final boolean embedded;

    public XmlStreamWriter(EncodingContext context, OutputStream outputStream, S element) throws XMLStreamException {
        this.context = Objects.requireNonNull(context);
        this.outputStream = Objects.requireNonNull(outputStream);
        this.element = element;
        this.encoderRepository = (EncoderRepository)context.require((Enum)EncoderFlags.ENCODER_REPOSITORY);
        this.xmlOptions = (Supplier)context.get((Enum)XmlEncoderFlags.XML_OPTIONS, XmlOptions::new);
        this.xmlVersion = (String)context.get((Enum)XmlEncoderFlags.XML_VERSION, (Object)"1.0");
        this.xmlEncoding = (String)context.get((Enum)EncoderFlags.ENCODING, (Object)StandardCharsets.UTF_8.name());
        this.embedded = context.getBoolean((Enum)StreamingEncoderFlags.EMBEDDED);
        if (context.has((Enum)XmlStreamEncoderFlags.XML_WRITER)) {
            this.writer = (ExtendedXMLStreamWriter)context.require((Enum)XmlStreamEncoderFlags.XML_WRITER);
            this.close = false;
        } else {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            if (outputFactory.isPropertySupported(OUTPUT_PROPERTY_ESCAPE_CHARACTERS)) {
                outputFactory.setProperty(OUTPUT_PROPERTY_ESCAPE_CHARACTERS, false);
            }
            this.writer = new IndentingXMLStreamWriter(outputFactory.createXMLStreamWriter(this.outputStream, this.xmlEncoding), 2);
            this.context = this.context.with((Enum)XmlStreamEncoderFlags.XML_WRITER, (Object)this.writer);
            this.close = true;
        }
    }

    protected S getElement() {
        return this.element;
    }

    protected XmlOptions getXmlOptions() {
        return this.xmlOptions.get();
    }

    protected OutputStream getOutputStream() throws XMLStreamException {
        this.flush();
        return this.outputStream;
    }

    protected EncodingContext getContext() {
        return this.context;
    }

    protected void attr(QName name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), value);
    }

    protected void attr(String name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name, value);
    }

    protected void attr(String namespace, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespace, localName, value);
    }

    protected void namespace(String prefix, String namespace) throws XMLStreamException {
        String ns = this.writer.getNamespaceContext().getNamespaceURI(prefix);
        if (ns == null || ns.isEmpty()) {
            this.writer.writeNamespace(prefix, namespace);
        } else if (!ns.equals(namespace)) {
            throw XmlStreamWriter.prefixAlreadyBound(prefix, ns);
        }
    }

    protected void start(QName name) throws XMLStreamException {
        boolean alreadySet;
        String prefix = name.getPrefix();
        String ns = this.writer.getNamespaceContext().getNamespaceURI(prefix);
        boolean bl = alreadySet = ns != null && !ns.isEmpty();
        if (alreadySet && !ns.equals(name.getNamespaceURI())) {
            throw XmlStreamWriter.prefixAlreadyBound(prefix, ns);
        }
        this.writer.writeStartElement(prefix, name.getLocalPart(), name.getNamespaceURI());
        if (!alreadySet) {
            this.writer.writeNamespace(prefix, name.getNamespaceURI());
        }
    }

    protected void start() throws XMLStreamException {
        if (!this.embedded) {
            this.writer.writeStartDocument(this.context.getEncoding(), this.xmlVersion);
        }
    }

    protected void empty(QName name) throws XMLStreamException {
        this.writer.writeEmptyElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
    }

    protected void chars(String chars) throws XMLStreamException {
        this.chars(chars, true);
    }

    protected void chars(String chars, boolean escape) throws XMLStreamException {
        this.writer.writeCharacters(escape ? XmlEscapers.xmlContentEscaper().escape(chars) : chars);
    }

    protected void end(QName name) throws XMLStreamException {
        this.writer.writeEndElement();
    }

    protected void end() throws XMLStreamException {
        if (!this.embedded) {
            this.writer.writeEndDocument();
        }
    }

    protected void endInline(QName name) throws XMLStreamException {
        this.end(name);
    }

    protected void finish() throws XMLStreamException {
        this.flush();
        if (this.close) {
            this.writer.close();
        }
    }

    protected void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public abstract void write() throws XMLStreamException, EncodingException;

    protected void rawText(String text) throws XMLStreamException {
        this.writer.writeXML(text);
    }

    protected String getReplacement(QName qname) {
        StringBuilder builder = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)qname.getPrefix())) {
            builder.append(qname.getPrefix());
            builder.append(':');
        }
        builder.append(qname.getLocalPart());
        return builder.toString();
    }

    protected void writeXmlObject(XmlObject xmlObject, QName qname) throws XMLStreamException {
        if (xmlObject != null) {
            String s = xmlObject.xmlText(this.getXmlOptions());
            this.rawText(s.replaceAll(XML_FRAGMENT, this.getReplacement(qname)));
        }
    }

    protected void writeXmlObject(XmlObject xmlObject) throws XMLStreamException {
        if (xmlObject != null) {
            this.rawText(xmlObject.xmlText(this.getXmlOptions()));
        }
    }

    protected void schemaLocation(Set<SchemaLocation> schemaLocations) throws XMLStreamException {
        String merged = N52XmlHelper.mergeSchemaLocationsToString(schemaLocations);
        if (!Strings.isNullOrEmpty((String)merged)) {
            this.namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.attr(W3CConstants.QN_SCHEMA_LOCATION_PREFIXED, merged);
        }
    }

    protected void time(TimeInstant time) throws XMLStreamException {
        this.time(time.getTimePosition());
    }

    protected void time(TimePosition time) throws XMLStreamException {
        this.chars(DateTimeHelper.formatDateTime2IsoString((DateTime)time.getTime()));
    }

    protected void addXlinkHrefAttr(String value) throws XMLStreamException {
        this.attr(W3CConstants.QN_XLINK_HREF, value);
    }

    protected void addXlinkTitleAttr(String value) throws XMLStreamException {
        this.attr(W3CConstants.QN_XLINK_TITLE, value);
    }

    protected <T, S> Optional<Encoder<T, S>> tryGetEncoder(EncoderKey key) {
        return this.encoderRepository.tryGetEncoder(key, new EncoderKey[0]);
    }

    protected <T, S> Encoder<T, S> getEncoder(EncoderKey key) throws NoEncoderForKeyException {
        return (Encoder)this.encoderRepository.tryGetEncoder(key, new EncoderKey[0]).orElseThrow(() -> new NoEncoderForKeyException((Object)key));
    }

    protected <T, S> Encoder<T, S> getEncoder(String namespace, Object o) throws NoEncoderForKeyException {
        return this.getEncoder((EncoderKey)new XmlEncoderKey(namespace, o.getClass()));
    }

    protected <T, S> Optional<Encoder<T, S>> getEncoder() {
        return this.getContext().get((Enum)StreamingEncoderFlags.ENCODER);
    }

    protected boolean isAddSchemaLocation() {
        return this.getContext().getBoolean((Enum)XmlEncoderFlags.ADD_SCHEMA_LOCATION);
    }

    protected Optional<String> getEncodeNamespace() {
        return this.getContext().get((Enum)XmlEncoderFlags.ENCODE_NAMESPACE);
    }

    private static XMLStreamException prefixAlreadyBound(String prefix, String ns) {
        return new XMLStreamException("Prefix <" + prefix + "> is already bound to <" + ns + ">");
    }
}

