/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.write.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.n52.svalbard.write.util.DelegatingXMLStreamWriter;
import org.n52.svalbard.write.util.ExtendedXMLStreamWriter;

public class IndentingXMLStreamWriter
extends DelegatingXMLStreamWriter
implements ExtendedXMLStreamWriter {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\\r?\\n");
    private static final String NEW_LINE = "\n";
    private final Stack<State> stateStack = new Stack();
    private final String indent;
    private State state = State.SEEN_NOTHING;
    private int depth;

    public IndentingXMLStreamWriter(XMLStreamWriter writer, String indent) {
        super(writer);
        this.indent = indent;
    }

    public IndentingXMLStreamWriter(XMLStreamWriter writer, int indent) {
        this(writer, IndentingXMLStreamWriter.repeat(" ", indent));
    }

    private void onStartElement() throws XMLStreamException {
        this.stateStack.push(State.SEEN_ELEMENT);
        this.state = State.SEEN_NOTHING;
        if (this.depth > 0) {
            this.writeNewLine();
        }
        this.writeIndent();
        ++this.depth;
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (this.state == State.SEEN_ELEMENT) {
            this.writeNewLine();
            this.writeIndent();
        }
        this.state = this.stateStack.pop();
    }

    private void onEmptyElement() throws XMLStreamException {
        this.state = State.SEEN_ELEMENT;
        if (this.depth > 0) {
            this.writeNewLine();
        }
        this.writeIndent();
    }

    private void onData() {
        this.state = State.SEEN_DATA;
    }

    private void writeNewLine() throws XMLStreamException {
        super.writeCharacters(NEW_LINE);
    }

    private void writeIndent() throws XMLStreamException {
        for (int i = 0; i < this.depth; ++i) {
            super.writeCharacters(this.indent);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        super.writeStartDocument();
        this.writeNewLine();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        super.writeStartDocument(version);
        this.writeNewLine();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        super.writeStartDocument(encoding, version);
        this.writeNewLine();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        super.writeEndElement();
    }

    @Override
    public void writeXML(String text) throws XMLStreamException {
        String[] lines = NEW_LINE_PATTERN.split(text.trim());
        Iterator<String> iter = Arrays.asList(lines).iterator();
        while (iter.hasNext()) {
            this.writeNewLine();
            this.writeIndent();
            super.writeCharacters(iter.next());
        }
        this.state = State.SEEN_ELEMENT;
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.onData();
        String[] lines = NEW_LINE_PATTERN.split(text.trim());
        if (lines.length <= 1) {
            super.writeCharacters(text.trim());
        } else {
            Iterator<String> iter = Arrays.asList(lines).iterator();
            while (iter.hasNext()) {
                this.writeNewLine();
                this.writeIndent();
                super.writeCharacters(iter.next());
            }
            this.state = State.SEEN_ELEMENT;
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.onData();
        super.writeCData(data);
    }

    private static String repeat(String s, int times) {
        StringBuilder builder = new StringBuilder(s.length() * times);
        for (int i = 0; i < times; ++i) {
            builder.append(s);
        }
        return builder.toString();
    }

    private static enum State {
        SEEN_NOTHING,
        SEEN_ELEMENT,
        SEEN_DATA;

    }
}

