/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.n52.javaps.algorithm.AlgorithmRepository;
import org.n52.javaps.algorithm.IAlgorithm;
import org.n52.javaps.description.TypedProcessDescription;
import org.n52.shetland.ogc.ows.OwsCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderAlgorithmRepository
implements AlgorithmRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLoaderAlgorithmRepository.class);
    private final Map<OwsCode, Class<? extends IAlgorithm>> currentAlgorithms = this.loadAlgorithms();

    private Map<OwsCode, Class<? extends IAlgorithm>> loadAlgorithms() {
        HashMap<OwsCode, Class<? extends IAlgorithm>> result = new HashMap<OwsCode, Class<? extends IAlgorithm>>();
        ServiceLoader<IAlgorithm> loader = ServiceLoader.load(IAlgorithm.class);
        for (IAlgorithm ia : loader) {
            LOG.debug("Adding algorithm with identifier {} and class {}", (Object)ia.getDescription().getId(), (Object)ia.getClass().getCanonicalName());
            result.put(ia.getDescription().getId(), ia.getClass());
        }
        return result;
    }

    @Override
    public Set<OwsCode> getAlgorithmNames() {
        return this.currentAlgorithms.keySet();
    }

    @Override
    public Optional<IAlgorithm> getAlgorithm(OwsCode processID) {
        Class<? extends IAlgorithm> clazz = this.currentAlgorithms.get(processID);
        if (clazz != null) {
            try {
                return Optional.of(clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<TypedProcessDescription> getProcessDescription(OwsCode processID) {
        return this.getAlgorithm(processID).map(IAlgorithm::getDescription);
    }

    @Override
    public boolean containsAlgorithm(OwsCode processID) {
        return this.currentAlgorithms.containsKey(processID);
    }
}

