/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.stream.Collectors;
import org.n52.javaps.algorithm.annotation.AbstractDataBinding;
import org.n52.javaps.description.TypedProcessInputDescription;
import org.n52.javaps.io.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractInputBinding<M extends AccessibleObject>
extends AbstractDataBinding<M, TypedProcessInputDescription<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInputBinding.class);
    private static final String INTERNAL_ERROR_PROCESSING_INPUTS = "Internal error processing inputs";
    private final String unableToInferConcreteType = "Unable to infer concrete type information for {}";

    AbstractInputBinding(M member) {
        super(member);
    }

    @Override
    public Type getType() {
        Type memberType;
        Type inputType = memberType = this.getMemberType();
        if (memberType instanceof Class) {
            Class memberClass = (Class)memberType;
            if (List.class.isAssignableFrom(memberClass)) {
                inputType = this.getNotParameterizedType();
            }
        } else if (memberType instanceof ParameterizedType) {
            ParameterizedType parameterizedMemberType = (ParameterizedType)memberType;
            Class rawClass = (Class)parameterizedMemberType.getRawType();
            if (List.class.isAssignableFrom(rawClass)) {
                inputType = parameterizedMemberType.getActualTypeArguments()[0];
            }
        } else {
            LOGGER.error("Unable to infer concrete type information for {}", this.getMember());
        }
        return inputType;
    }

    public boolean isMemberTypeList() {
        Type memberType = this.getMemberType();
        if (memberType instanceof Class) {
            return List.class.isAssignableFrom((Class)memberType);
        }
        if (memberType instanceof ParameterizedType) {
            Class rawClass = (Class)((ParameterizedType)memberType).getRawType();
            return List.class.isAssignableFrom(rawClass);
        }
        LOGGER.error("Unable to infer concrete type information for {}", this.getMember());
        return false;
    }

    protected boolean checkType() {
        Type inputPayloadType = this.getPayloadType();
        Class bindingPayloadClass = ((TypedProcessInputDescription)this.getDescription()).getPayloadType();
        if (inputPayloadType instanceof Class) {
            return ((Class)inputPayloadType).isAssignableFrom(bindingPayloadClass);
        }
        if (inputPayloadType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)inputPayloadType;
            return ((Class)parameterizedType.getRawType()).isAssignableFrom(bindingPayloadClass);
        }
        if (inputPayloadType instanceof WildcardType) {
            WildcardType inputTypeWildcardType = (WildcardType)inputPayloadType;
            Type[] lowerBounds = inputTypeWildcardType.getLowerBounds();
            Type[] upperBounds = inputTypeWildcardType.getUpperBounds();
            Class lowerBoundClass = null;
            Class upperBoundClass = null;
            if (lowerBounds != null && lowerBounds.length > 0) {
                if (lowerBounds[0] instanceof Class) {
                    lowerBoundClass = (Class)lowerBounds[0];
                } else if (lowerBounds[0] instanceof ParameterizedType) {
                    lowerBoundClass = (Class)((ParameterizedType)lowerBounds[0]).getRawType();
                }
            }
            if (upperBounds != null && upperBounds.length > 0) {
                if (upperBounds[0] instanceof Class) {
                    upperBoundClass = (Class)upperBounds[0];
                } else if (upperBounds[0] instanceof ParameterizedType) {
                    upperBoundClass = (Class)((ParameterizedType)upperBounds[0]).getRawType();
                }
            }
            return !(upperBoundClass != null && !upperBoundClass.isAssignableFrom(bindingPayloadClass) || lowerBounds != null && !bindingPayloadClass.isAssignableFrom(lowerBoundClass));
        }
        LOGGER.error("Unable to infer assignability from type for {}", this.getMember());
        return false;
    }

    public Object unbindInput(List<Data<?>> inputs) {
        if (inputs != null && inputs.size() > 0) {
            if (this.isMemberTypeList()) {
                return inputs.stream().map(bound -> this.payloadToInput(bound.getPayload())).collect(Collectors.toList());
            }
            if (inputs.size() == 1) {
                return this.payloadToInput(inputs.get(0).getPayload());
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean validate() {
        if (!this.checkModifier()) {
            LOGGER.error("Field {} with input annotation can't be used, not public.", this.getMember());
            return false;
        }
        if (((TypedProcessInputDescription)this.getDescription()).getOccurence().isMultiple() && !this.isMemberTypeList()) {
            LOGGER.error("Field {} with input annotation can't be used, occurence is {} and field is not of type List", this.getMember(), (Object)((TypedProcessInputDescription)this.getDescription()).getOccurence());
            return false;
        }
        if (!this.checkType()) {
            LOGGER.error("Field {} with input annotation can't be used, unable to safely assign field using binding payload type", this.getMember());
            return false;
        }
        return true;
    }

    public abstract void set(Object var1, List<Data<?>> var2);

    public static AbstractInputBinding<Field> field(Field field) {
        return new InputFieldBinding(field);
    }

    public static AbstractInputBinding<Method> method(Method method) {
        return new InputMethodBinding(method);
    }

    private static class InputMethodBinding
    extends AbstractInputBinding<Method> {
        InputMethodBinding(Method method) {
            super(method);
        }

        @Override
        public Type getMemberType() {
            Type[] genericParameterTypes = ((Method)this.getMember()).getGenericParameterTypes();
            return genericParameterTypes.length == 0 ? Void.class : genericParameterTypes[0];
        }

        @Override
        public void set(Object instance, List<Data<?>> inputs) {
            try {
                ((Method)this.getMember()).invoke(instance, this.unbindInput(inputs));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(AbstractInputBinding.INTERNAL_ERROR_PROCESSING_INPUTS, ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                throw new RuntimeException(cause.getMessage(), cause);
            }
        }
    }

    private static class InputFieldBinding
    extends AbstractInputBinding<Field> {
        InputFieldBinding(Field field) {
            super(field);
        }

        @Override
        public Type getMemberType() {
            return ((Field)this.getMember()).getGenericType();
        }

        @Override
        public void set(Object instance, List<Data<?>> inputs) {
            try {
                ((Field)this.getMember()).set(instance, this.unbindInput(inputs));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(AbstractInputBinding.INTERNAL_ERROR_PROCESSING_INPUTS, ex);
            }
        }
    }
}

