/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import com.google.common.base.Strings;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.n52.janmayen.stream.MoreCollectors;
import org.n52.janmayen.stream.Streams;
import org.n52.javaps.algorithm.annotation.AbstractDataBinding;
import org.n52.javaps.algorithm.annotation.AbstractInputBinding;
import org.n52.javaps.algorithm.annotation.AbstractOutputBinding;
import org.n52.javaps.algorithm.annotation.Algorithm;
import org.n52.javaps.algorithm.annotation.AnnotationParser;
import org.n52.javaps.algorithm.annotation.BoundingBoxInputAnnotationParser;
import org.n52.javaps.algorithm.annotation.BoundingBoxOutputAnnotationParser;
import org.n52.javaps.algorithm.annotation.ComplexInputAnnotationParser;
import org.n52.javaps.algorithm.annotation.ComplexOutputAnnotationParser;
import org.n52.javaps.algorithm.annotation.ExecuteAnnotationParser;
import org.n52.javaps.algorithm.annotation.ExecuteBinding;
import org.n52.javaps.algorithm.annotation.LiteralInputAnnotationParser;
import org.n52.javaps.algorithm.annotation.LiteralOutputAnnotationParser;
import org.n52.javaps.description.TypedProcessDescription;
import org.n52.javaps.description.TypedProcessInputDescription;
import org.n52.javaps.description.TypedProcessOutputDescription;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.javaps.description.impl.TypedProcessDescriptionImpl;
import org.n52.javaps.io.InputHandlerRepository;
import org.n52.javaps.io.OutputHandlerRepository;
import org.n52.javaps.io.literal.LiteralTypeRepository;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.description.ProcessInputDescription;
import org.n52.shetland.ogc.wps.description.ProcessOutputDescription;

public class AnnotatedAlgorithmMetadata {
    private static final String DUPLICATE_IDENTIFIER = "duplicated identifier: ";
    private final Class<?> algorithmClass;
    private final Map<OwsCode, AbstractOutputBinding<?>> outputBindings;
    private final Map<OwsCode, AbstractInputBinding<?>> inputBindings;
    private final ExecuteBinding executeBinding;
    private final TypedProcessDescription description;
    private final TypedProcessDescriptionFactory descriptionFactory = new TypedProcessDescriptionFactory();

    public AnnotatedAlgorithmMetadata(Class<?> algorithmClass, InputHandlerRepository parserRepository, OutputHandlerRepository generatorRepository, LiteralTypeRepository literalTypeRepository) {
        this.algorithmClass = Objects.requireNonNull(algorithmClass);
        this.checkDefaultConstructor(algorithmClass);
        this.executeBinding = this.getExecuteBinding(algorithmClass);
        this.inputBindings = this.getInputBindings(algorithmClass, parserRepository, literalTypeRepository);
        this.outputBindings = this.getOutputBindings(algorithmClass, generatorRepository, literalTypeRepository);
        this.description = this.getDescription(algorithmClass, this.inputBindings, this.outputBindings);
    }

    public Class<?> getAlgorithmClass() {
        return this.algorithmClass;
    }

    Map<OwsCode, AbstractOutputBinding<?>> getOutputBindings() {
        return Collections.unmodifiableMap(this.outputBindings);
    }

    private Map<OwsCode, AbstractOutputBinding<?>> getOutputBindings(Class<?> algorithmClass, OutputHandlerRepository generatorRepository, LiteralTypeRepository literalTypeRepository) {
        Stream<AbstractOutputBinding> s1 = this.parseElements(this.getFields(algorithmClass), Arrays.asList(new LiteralOutputAnnotationParser<Field, AbstractOutputBinding>(AbstractOutputBinding::field, literalTypeRepository), new ComplexOutputAnnotationParser<Field, AbstractOutputBinding>(AbstractOutputBinding::field, generatorRepository), new BoundingBoxOutputAnnotationParser<Field, AbstractOutputBinding>(AbstractOutputBinding::field))).map(x -> x);
        Stream<AbstractOutputBinding> s2 = this.parseElements(this.getMethods(algorithmClass), Arrays.asList(new LiteralOutputAnnotationParser<Method, AbstractOutputBinding>(AbstractOutputBinding::method, literalTypeRepository), new ComplexOutputAnnotationParser<Method, AbstractOutputBinding>(AbstractOutputBinding::method, generatorRepository), new BoundingBoxOutputAnnotationParser<Method, AbstractOutputBinding>(AbstractOutputBinding::method))).map(x -> x);
        BinaryOperator merger = Streams.throwingMerger((a, b) -> new RuntimeException(DUPLICATE_IDENTIFIER + ((TypedProcessOutputDescription)a.getDescription()).getId()));
        Collector<AbstractOutputBinding, ?, Map> collector = Collectors.toMap(b -> ((TypedProcessOutputDescription)b.getDescription()).getId(), Function.identity(), merger, LinkedHashMap::new);
        return Collections.unmodifiableMap(Stream.concat(s1, s2).collect(collector));
    }

    Map<OwsCode, AbstractInputBinding<?>> getInputBindings() {
        return Collections.unmodifiableMap(this.inputBindings);
    }

    private Map<OwsCode, AbstractInputBinding<?>> getInputBindings(Class<?> algorithmClass, InputHandlerRepository parserRepository, LiteralTypeRepository literalTypeRepository) {
        Stream<AbstractInputBinding> s1 = this.parseElements(this.getFields(algorithmClass), Arrays.asList(new LiteralInputAnnotationParser<Field, AbstractInputBinding>(AbstractInputBinding::field, literalTypeRepository), new ComplexInputAnnotationParser<Field, AbstractInputBinding>(AbstractInputBinding::field, parserRepository), new BoundingBoxInputAnnotationParser<Field, AbstractInputBinding>(AbstractInputBinding::field))).map(x -> x);
        Stream<AbstractInputBinding> s2 = this.parseElements(this.getMethods(algorithmClass), Arrays.asList(new LiteralInputAnnotationParser<Method, AbstractInputBinding>(AbstractInputBinding::method, literalTypeRepository), new ComplexInputAnnotationParser<Method, AbstractInputBinding>(AbstractInputBinding::method, parserRepository), new BoundingBoxInputAnnotationParser<Method, AbstractInputBinding>(AbstractInputBinding::method))).map(x -> x);
        BinaryOperator merger = Streams.throwingMerger((a, b) -> new RuntimeException(DUPLICATE_IDENTIFIER + ((TypedProcessInputDescription)a.getDescription()).getId()));
        Collector<AbstractInputBinding, ?, LinkedHashMap> collector = Collectors.toMap(b -> ((TypedProcessInputDescription)b.getDescription()).getId(), Function.identity(), merger, LinkedHashMap::new);
        return Collections.unmodifiableMap(Stream.concat(s1, s2).collect(collector));
    }

    ExecuteBinding getExecuteBinding() {
        return this.executeBinding;
    }

    private ExecuteBinding getExecuteBinding(Class<?> algorithmClass) {
        ExecuteAnnotationParser parser = new ExecuteAnnotationParser();
        return (ExecuteBinding)this.getMethods(algorithmClass).filter(method -> method.isAnnotationPresent(parser.getSupportedAnnotation())).map(method -> (ExecuteBinding)parser.parse(method)).filter(Objects::nonNull).collect(MoreCollectors.toSingleResult(() -> new RuntimeException("Multiple execute method bindings encountered for class " + algorithmClass.getCanonicalName())));
    }

    public TypedProcessDescription getDescription() {
        return this.description;
    }

    private TypedProcessDescription getDescription(Class<?> algorithmClass, Map<OwsCode, AbstractInputBinding<?>> inputBindings, Map<OwsCode, AbstractOutputBinding<?>> outputBindings) {
        Function<AbstractInputBinding, TypedProcessInputDescription> getInputDescription = AbstractDataBinding::getDescription;
        List<ProcessInputDescription> inputs = inputBindings.values().stream().map(getInputDescription).collect(Collectors.toList());
        Function<AbstractOutputBinding, TypedProcessOutputDescription> getOutputDescription = AbstractDataBinding::getDescription;
        List<ProcessOutputDescription> outputs = outputBindings.values().stream().map(getOutputDescription).collect(Collectors.toList());
        return this.getDescription(algorithmClass, inputs, outputs);
    }

    private TypedProcessDescription getDescription(Class<?> algorithmClass, List<ProcessInputDescription> inputs, List<ProcessOutputDescription> outputs) {
        Algorithm annotation = this.getProcessAnnotation(algorithmClass);
        String identifier = Strings.emptyToNull((String)annotation.identifier()) == null ? algorithmClass.getCanonicalName() : annotation.identifier();
        return ((TypedProcessDescriptionImpl.Builder)((TypedProcessDescriptionImpl.Builder)((TypedProcessDescriptionImpl.Builder)((TypedProcessDescriptionImpl.Builder)((TypedProcessDescriptionImpl.Builder)((TypedProcessDescriptionImpl.Builder)((TypedProcessDescriptionImpl.Builder)((TypedProcessDescriptionImpl.Builder)this.descriptionFactory.process().withIdentifier(identifier)).withTitle(annotation.title())).withAbstract(annotation.abstrakt())).withVersion(annotation.version())).storeSupported(annotation.storeSupported())).statusSupported(annotation.statusSupported())).withInput(inputs)).withOutput(outputs)).build();
    }

    public <M extends AccessibleObject, B extends AbstractDataBinding<? super M, ?>> Stream<? extends B> parseElements(Stream<M> members, List<? extends AnnotationParser<?, M, ? extends B>> outputParser) {
        return members.flatMap(member -> outputParser.stream().filter(parser -> member.isAnnotationPresent(parser.getSupportedAnnotation())).map(parser -> (AbstractDataBinding)parser.parse(member)).filter(Objects::nonNull));
    }

    private void checkDefaultConstructor(Class<?> algorithmClass) throws RuntimeException {
        try {
            Constructor<?> defaultConstructor = algorithmClass.getConstructor(new Class[0]);
            if (!Modifier.isPublic(defaultConstructor.getModifiers())) {
                throw new RuntimeException("Classes with Algorithm annotation require public no-arg constructor, error introspecting " + algorithmClass.getName());
            }
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new RuntimeException("Current security policy limits use of reflection, error introspecting " + algorithmClass.getName());
        }
    }

    private Algorithm getProcessAnnotation(Class<?> algorithmClass1) throws RuntimeException {
        Algorithm annotation = algorithmClass1.getAnnotation(Algorithm.class);
        if (annotation == null) {
            throw new RuntimeException("Class isn't annotated with an Algorithm annotation");
        }
        return annotation;
    }

    private Stream<Method> getMethods(Class<?> clazz) {
        return this.asClassStream(clazz).map(Class::getDeclaredMethods).flatMap(Arrays::stream);
    }

    private Stream<Field> getFields(Class<?> clazz) {
        return this.asClassStream(clazz).map(Class::getDeclaredFields).flatMap(Arrays::stream);
    }

    private Stream<Class<?>> getSuperTypeStream(Class<?> c) {
        return Stream.concat(Stream.of(c.getSuperclass()), Arrays.stream(c.getInterfaces())).filter(Objects::nonNull).flatMap(this::getSuperTypeStream).distinct();
    }

    private Stream<Class<?>> asClassStream(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), this.getSuperTypeStream(clazz));
    }
}

