/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import org.n52.javaps.algorithm.annotation.AbstractInputAnnotationParser;
import org.n52.javaps.algorithm.annotation.AbstractInputBinding;
import org.n52.javaps.algorithm.annotation.BoundingBoxInput;
import org.n52.javaps.description.TypedBoundingBoxInputDescription;
import org.n52.javaps.description.impl.TypedBoundingBoxInputDescriptionImpl;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.shetland.ogc.ows.OwsCRS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoundingBoxInputAnnotationParser<M extends AccessibleObject, B extends AbstractInputBinding<M>>
extends AbstractInputAnnotationParser<BoundingBoxInput, M, B> {
    private static final Logger LOG = LoggerFactory.getLogger(BoundingBoxInputAnnotationParser.class);

    BoundingBoxInputAnnotationParser(Function<M, B> bindingFunction) {
        super(bindingFunction);
    }

    @Override
    protected TypedBoundingBoxInputDescription createDescription(BoundingBoxInput annotation, B binding) {
        URI defaultCRSURI = null;
        try {
            defaultCRSURI = new URI(annotation.defaultCRSString());
        }
        catch (URISyntaxException e) {
            LOG.error("Could not create URI from String: " + annotation.defaultCRSString());
            defaultCRSURI = URI.create("http://www.opengis.net/def/crs/EPSG/0/4326");
        }
        return ((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)new TypedProcessDescriptionFactory().boundingBoxInput().withIdentifier(annotation.identifier())).withAbstract(annotation.abstrakt())).withTitle(annotation.title())).withMinimalOccurence(annotation.minOccurs())).withMaximalOccurence(annotation.maxOccurs())).withDefaultCRS(new OwsCRS(defaultCRSURI))).build();
    }

    @Override
    public Class<? extends BoundingBoxInput> getSupportedAnnotation() {
        return BoundingBoxInput.class;
    }
}

