/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.n52.javaps.algorithm.annotation.AbstractDataBinding;
import org.n52.javaps.algorithm.annotation.AbstractInputAnnotationParser;
import org.n52.javaps.algorithm.annotation.AbstractInputBinding;
import org.n52.javaps.algorithm.annotation.AnnotationParser;
import org.n52.javaps.algorithm.annotation.LiteralInput;
import org.n52.javaps.description.TypedLiteralInputDescription;
import org.n52.javaps.description.impl.TypedLiteralInputDescriptionImpl;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.javaps.io.literal.LiteralType;
import org.n52.javaps.io.literal.LiteralTypeRepository;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsAnyValue;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.wps.description.impl.LiteralDataDomainImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LiteralInputAnnotationParser<M extends AccessibleObject, B extends AbstractInputBinding<M>>
extends AbstractInputAnnotationParser<LiteralInput, M, B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationParser.class);
    private final LiteralTypeRepository literalTypeRepository;

    LiteralInputAnnotationParser(Function<M, B> bindingFunction, LiteralTypeRepository literalTypeRepository) {
        super(bindingFunction);
        this.literalTypeRepository = Objects.requireNonNull(literalTypeRepository, "literalDataManager");
    }

    private List<String> getEnumValues(B binding) {
        if (!((AbstractDataBinding)binding).isEnum()) {
            return Collections.emptyList();
        }
        Class enumType = (Class)((AbstractInputBinding)binding).getType();
        return Arrays.stream(enumType.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public TypedLiteralInputDescription createDescription(LiteralInput annotation, B binding) {
        LiteralType<?> bindingType = this.getLiteralType(annotation, binding);
        List<String> allowedValues = this.getAllowedValues(annotation, binding);
        TypedProcessDescriptionFactory descriptionFactory = new TypedProcessDescriptionFactory();
        return ((TypedLiteralInputDescriptionImpl.Builder)((TypedLiteralInputDescriptionImpl.Builder)((TypedLiteralInputDescriptionImpl.Builder)((TypedLiteralInputDescriptionImpl.Builder)((TypedLiteralInputDescriptionImpl.Builder)((TypedLiteralInputDescriptionImpl.Builder)((TypedLiteralInputDescriptionImpl.Builder)descriptionFactory.literalInput().withIdentifier(annotation.identifier())).withTitle(annotation.title())).withAbstract(annotation.abstrakt())).withMinimalOccurence(annotation.minOccurs())).withMaximalOccurence(this.getMaxOccurence(annotation, allowedValues))).withType(bindingType)).withDefaultLiteralDataDomain(((LiteralDataDomainImpl.Builder)((LiteralDataDomainImpl.Builder)((LiteralDataDomainImpl.Builder)descriptionFactory.literalDataDomain().withValueDescription((OwsPossibleValues)(allowedValues.isEmpty() ? OwsAnyValue.instance() : new OwsAllowedValues(allowedValues.stream().map(OwsValue::new))))).withDataType(bindingType.getDataType())).withDefaultValue(this.getDefaultValue(annotation, allowedValues))).withUOM(annotation.uom()))).build();
    }

    @Override
    public Class<? extends LiteralInput> getSupportedAnnotation() {
        return LiteralInput.class;
    }

    public LiteralType<?> getLiteralType(LiteralInput annotation, B binding) {
        Type payloadType = ((AbstractDataBinding)binding).getPayloadType();
        Class<? extends LiteralType> bindingType = annotation.binding();
        if (payloadType instanceof Class) {
            return this.literalTypeRepository.getLiteralType(bindingType, (Class)payloadType);
        }
        return this.literalTypeRepository.getLiteralType(bindingType);
    }

    private long getMaxOccurence(LiteralInput annotation, List<String> allowedValues) {
        if (annotation.maxOccurs() == -1L) {
            if (allowedValues.isEmpty()) {
                LOGGER.warn("Invalid maxOccurs \"ENUM_COUNT\" specified for for input {}, setting maxOccurs to {}", (Object)annotation.identifier(), (Object)annotation.minOccurs());
                return annotation.minOccurs() > 0L ? annotation.minOccurs() : 1L;
            }
            return allowedValues.size();
        }
        return annotation.maxOccurs();
    }

    private List<String> getAllowedValues(LiteralInput annotation, B binding) {
        List<String> enumValues = this.getEnumValues(binding);
        List<String> allowedValues = new ArrayList<String>(Arrays.asList(annotation.allowedValues()));
        if (!enumValues.isEmpty()) {
            if (!allowedValues.isEmpty()) {
                allowedValues.stream().filter(x -> !enumValues.contains(x)).peek(x -> LOGGER.warn("Invalid allowed value \"{}\" specified for for enumerated input {}", x, (Object)annotation.identifier())).forEach(allowedValues::remove);
            } else {
                allowedValues = enumValues;
            }
        }
        return allowedValues;
    }

    private String getDefaultValue(LiteralInput annotation, List<String> allowedValues) {
        String defaultValue = annotation.defaultValue();
        if (!(allowedValues.isEmpty() || annotation.defaultValue().isEmpty() || allowedValues.contains(annotation.defaultValue()))) {
            LOGGER.warn("Invalid default value \"{}\" specified for for enumerated input {}, ignoring.", (Object)defaultValue, (Object)annotation.identifier());
            defaultValue = null;
        }
        return defaultValue;
    }
}

