/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.engine;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.InputDecodingException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.OutputDefinition;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.StatusInfo;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.description.ProcessDescription;

public interface Engine {
    public Set<JobId> getJobIdentifiers();

    public Set<JobId> getJobIdentifiers(OwsCode var1);

    default public boolean hasJob(JobId jobId) {
        return this.getJobIdentifiers().contains(jobId);
    }

    public Set<OwsCode> getProcessIdentifiers();

    public Optional<ProcessDescription> getProcessDescription(OwsCode var1);

    default public boolean hasProcessDescription(OwsCode identifier) {
        return this.getProcessDescription(identifier).isPresent();
    }

    default public Set<ProcessDescription> getProcessDescriptions() {
        return this.getProcessIdentifiers().stream().map(this::getProcessDescription).map(Optional::get).collect(Collectors.toSet());
    }

    public StatusInfo dismiss(JobId var1) throws JobNotFoundException;

    public JobId execute(OwsCode var1, List<ProcessData> var2, List<OutputDefinition> var3, ResponseMode var4) throws ProcessNotFoundException, InputDecodingException;

    public StatusInfo getStatus(JobId var1) throws EngineException;

    public Future<Result> getResult(JobId var1) throws EngineException;
}

