/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.engine.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.util.MoreFiles;
import org.n52.janmayen.Chain;
import org.n52.janmayen.Json;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.janmayen.lifecycle.Destroyable;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.EngineProcessExecutionContext;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.engine.OutputNotFoundException;
import org.n52.javaps.engine.OutputReference;
import org.n52.javaps.engine.OutputReferencer;
import org.n52.javaps.engine.ResultPersistence;
import org.n52.javaps.engine.impl.ResolvableReferenceProcessData;
import org.n52.javaps.io.EncodingException;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.DataTransmissionMode;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.JobStatus;
import org.n52.shetland.ogc.wps.OutputDefinition;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.StatusInfo;
import org.n52.shetland.ogc.wps.data.Body;
import org.n52.shetland.ogc.wps.data.GroupProcessData;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;
import org.n52.shetland.ogc.wps.data.impl.FileBasedProcessData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class FileBasedResultPersistence
implements ResultPersistence,
Constructable,
Destroyable {
    private static final String GROUP_TYPE = "group";
    private static final String REFERENCE_TYPE = "reference";
    private static final String VALUE_TYPE = "value";
    private static final String META_JSON_FILE_NAME = ".meta.json";
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedResultPersistence.class);
    private static final String COULD_NOT_LIST = "Could not list ";
    private Timer timer;
    private Path basePath;
    private Duration duration = Duration.ofHours(2L);
    private Duration checkInterval = Duration.ofHours(1L);
    private Optional<OutputReferencer> referencer;

    @Setting(value="misc.baseDirectory")
    public void setBasePath(File baseDirectory) {
        this.basePath = baseDirectory.toPath();
    }

    @Setting(value="misc.duration")
    public void setDuration(String durationString) {
        this.duration = Duration.parse(durationString);
    }

    @Setting(value="misc.checkInterval")
    public void setCheckInterval(String checkIntervalString) {
        this.checkInterval = Duration.parse(checkIntervalString);
    }

    @Inject
    public void setReferencer(Optional<OutputReferencer> referencer) {
        this.referencer = Objects.requireNonNull(referencer);
    }

    public void setReferencer(OutputReferencer referencer) {
        this.setReferencer(Optional.ofNullable(referencer));
    }

    public void init() {
        this.timer = new Timer();
        CleanupTask task = new CleanupTask(this.basePath, this.duration);
        this.timer.scheduleAtFixedRate((TimerTask)task, 0L, this.checkInterval.toMillis());
    }

    public void destroy() {
        this.timer.cancel();
    }

    @Override
    public void save(EngineProcessExecutionContext context) {
        try {
            String jobId = context.getJobId().getValue();
            String processId = context.getProcessId().getValue();
            Path directory = Files.createDirectories(this.basePath.resolve(jobId), new FileAttribute[0]);
            OffsetDateTime expirationDate = this.getExpirationDate(directory);
            ObjectNode rootNode = Json.nodeFactory().objectNode().put("status", context.getJobStatus().getValue()).put("jobId", jobId).put("processId", processId).put("expirationDate", expirationDate.toString()).put("responseMode", context.getResponseMode().toString());
            try {
                this.persist(directory, context.getEncodedOutputs(), context.getOutputDefinitions(), rootNode.putArray("outputs"));
            }
            catch (Throwable ex) {
                LOG.error("Error executing job " + context.getJobId(), ex);
                rootNode.put("status", JobStatus.failed().getValue());
                rootNode.put("error", this.persistFailureCause(directory, ex).toString());
            }
            Files.write(directory.resolve(META_JSON_FILE_NAME), Json.print((JsonNode)rootNode).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            LOG.error("Error writing result for job " + context.getJobId(), (Throwable)ex);
        }
    }

    @Override
    public StatusInfo getStatus(JobId jobId) throws EngineException, JobNotFoundException {
        try {
            JsonNode jobMetadata = this.getJobMetadata(jobId);
            OffsetDateTime expirationDate = this.getExpirationDate(jobId);
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setJobId(jobId);
            statusInfo.setExpirationDate(expirationDate);
            statusInfo.setStatus(new JobStatus(jobMetadata.path("status").textValue()));
            return statusInfo;
        }
        catch (IOException ex) {
            throw new EngineException(ex);
        }
    }

    @Override
    public Result getResult(JobId jobId) throws JobNotFoundException, EngineException {
        try {
            Result result = new Result();
            result.setJobId(jobId);
            result.setExpirationDate(this.getExpirationDate(jobId));
            JsonNode node = this.getJobMetadata(jobId);
            ResponseMode.fromString((String)node.path("responseMode").textValue()).ifPresent(arg_0 -> ((Result)result).setResponseMode(arg_0));
            if (JobStatus.failed().getValue().equals(node.path("status").textValue())) {
                Path path = Paths.get(node.path("error").textValue(), new String[0]);
                try {
                    ObjectInputStream in = new ObjectInputStream(Files.newInputStream(path, new OpenOption[0]));
                    Throwable throwable = null;
                    try {
                        try {
                            throw new EngineException((Throwable)in.readObject());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new EngineException(ex);
                }
            }
            for (JsonNode outputNode : node.path("outputs")) {
                OwsCode identifier = this.decodeIdentifier(outputNode);
                OutputReference reference = new OutputReference(jobId, identifier);
                result.addOutput(this.decodeOutput(reference, outputNode, false));
            }
            return result;
        }
        catch (IOException ex) {
            throw new EngineException(ex);
        }
    }

    private OffsetDateTime getExpirationDate(Path directory) throws IOException {
        return FileBasedResultPersistence.getLastModifiedTimeChecked(directory).plus(this.duration);
    }

    private OffsetDateTime getExpirationDate(JobId jobId) throws JobNotFoundException, IOException {
        return this.getExpirationDate(this.getJobDirectory(jobId));
    }

    private Map<OwsCode, OutputDefinition> byId(Collection<OutputDefinition> definitions) {
        return definitions.stream().collect(Collectors.toMap(OutputDefinition::getId, Function.identity()));
    }

    private void encodeFormat(Format format, ObjectNode formatNode) {
        formatNode.put("mimeType", (String)format.getMimeType().orElse(null)).put("schema", (String)format.getSchema().orElse(null)).put("encoding", (String)format.getEncoding().orElse(null));
    }

    private Format decodeFormat(JsonNode node) {
        return new Format(node.path("mimeType").textValue(), node.path("encoding").textValue(), node.path("schema").textValue());
    }

    private void persist(Path directory, List<ProcessData> outputs, Map<OwsCode, OutputDefinition> outputDefinitions, ArrayNode outputsNode) throws IOException, EncodingException {
        for (ProcessData data : outputs) {
            OutputDefinition definition = outputDefinitions.get(data.getId());
            ObjectNode outputNode = outputsNode.addObject();
            outputNode.putObject("id").put(VALUE_TYPE, data.getId().getValue()).put("codeSpace", (String)data.getId().getCodeSpace().map(URI::toString).orElse(null));
            if (data.isGroup()) {
                outputNode.put("type", GROUP_TYPE);
                this.persist(directory, data.asGroup().getElements(), definition.getOutputsById(), outputNode.putArray("outputs"));
                continue;
            }
            if (data.isReference()) {
                outputNode.put("type", REFERENCE_TYPE);
                this.encodeFormat(data.asReference().getFormat(), outputNode.putObject("format"));
                outputNode.put("href", data.asReference().getURI().toString());
                if (!data.asReference().getBody().isPresent()) continue;
                Body body = (Body)data.asReference().getBody().get();
                if (body.isInline()) {
                    outputNode.put("body", body.asInline().getBody());
                    continue;
                }
                if (!body.isReferenced()) continue;
                outputNode.put("bodyHref", body.asReferenced().getHref().toString());
                continue;
            }
            if (!data.isValue()) continue;
            ValueProcessData valueData = data.asValue();
            outputNode.put("type", VALUE_TYPE);
            outputNode.put("dataTransmissionMode", definition.getDataTransmissionMode().toString());
            this.encodeFormat(valueData.getFormat(), outputNode.putObject("format"));
            Path outputFile = Files.createTempFile(directory, null, null, new FileAttribute[0]);
            outputNode.put("file", outputFile.toString());
            InputStream in = valueData.getData();
            Throwable throwable = null;
            try {
                Files.copy(in, outputFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private Path getJobDirectory(JobId jobId) throws JobNotFoundException {
        Path directory = this.basePath.resolve(jobId.getValue());
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new JobNotFoundException(jobId);
        }
        return directory;
    }

    private JsonNode getJobMetadata(JobId jobId) throws JobNotFoundException, IOException {
        return Json.loadPath((Path)this.getJobDirectory(jobId).resolve(META_JSON_FILE_NAME));
    }

    @Override
    public ProcessData getOutput(OutputReference reference) throws EngineException {
        try {
            return this.getOutput(reference, reference.getOutputId(), this.getJobMetadata(reference.getJobId()).path("outputs"));
        }
        catch (IOException ex) {
            throw new EngineException(ex);
        }
    }

    private ProcessData getOutput(OutputReference reference, Chain<OwsCode> tail, JsonNode outputs) throws OutputNotFoundException, IOException {
        for (JsonNode node : outputs) {
            OwsCode id = this.decodeIdentifier(node);
            if (!id.equals(tail.first())) continue;
            Optional next = tail.tail();
            if (next.isPresent()) {
                return this.getOutput(reference, (Chain<OwsCode>)((Chain)next.get()), outputs.path("outputs"));
            }
            return this.decodeOutput(reference, node, true);
        }
        throw new OutputNotFoundException();
    }

    private ProcessData decodeOutput(OutputReference reference, JsonNode node, boolean dereference) throws IOException {
        switch (node.path("type").textValue()) {
            case "reference": {
                return this.decodeReferenceData(reference, node);
            }
            case "value": {
                return this.decodeValueData(reference, node, dereference);
            }
            case "group": {
                return this.decodeGroupData(reference, node);
            }
        }
        throw new IOException("Unsupported output type");
    }

    private OwsCode decodeIdentifier(JsonNode node) {
        URI codeSpace = Optional.ofNullable(node.path("id").path("codeSpace").textValue()).map(URI::create).orElse(null);
        String value = node.path("id").path(VALUE_TYPE).textValue();
        OwsCode id = new OwsCode(value, codeSpace);
        return id;
    }

    private ProcessData decodeReferenceData(OutputReference reference, JsonNode node) {
        ResolvableReferenceProcessData referenceProcessData = new ResolvableReferenceProcessData((OwsCode)reference.getOutputId().last());
        referenceProcessData.setURI(URI.create(node.path("href").textValue()));
        referenceProcessData.setFormat(this.decodeFormat(node.path("format")));
        if (!node.path("body").isMissingNode()) {
            referenceProcessData.setBody(Body.inline((String)node.path("body").textValue()));
        } else if (!node.path("bodyHref").isMissingNode()) {
            referenceProcessData.setBody(Body.reference((String)node.path("bodyHref").textValue()));
        }
        return referenceProcessData;
    }

    private ProcessData decodeValueData(OutputReference reference, JsonNode node, boolean dereference) {
        DataTransmissionMode mode = DataTransmissionMode.fromString((String)node.path("dataTransmissionMode").textValue()).orElse(DataTransmissionMode.VALUE);
        Format format = this.decodeFormat(node.path("format"));
        if (dereference || mode == DataTransmissionMode.VALUE || !this.referencer.isPresent()) {
            Path path = Paths.get(node.path("file").textValue(), new String[0]);
            return new FileBasedProcessData((OwsCode)reference.getOutputId().last(), format, path);
        }
        URI uri = this.referencer.get().reference(reference);
        return new ResolvableReferenceProcessData((OwsCode)reference.getOutputId().last(), format, uri);
    }

    private ProcessData decodeGroupData(OutputReference reference, JsonNode node) throws IOException {
        GroupProcessData groupProcessData = new GroupProcessData((OwsCode)reference.getOutputId().last());
        for (JsonNode childNode : node.path("outputs")) {
            OutputReference childRefernce = reference.child(this.decodeIdentifier(childNode));
            ProcessData childOutput = this.decodeOutput(childRefernce, childNode, false);
            groupProcessData.addElement(childOutput);
        }
        return groupProcessData;
    }

    private Path persistFailureCause(Path directory, Throwable ex) throws IOException {
        Path outputFile = Files.createTempFile(directory, null, null, new FileAttribute[0]);
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]));){
            out.writeObject(ex);
        }
        return outputFile;
    }

    @Override
    public Set<JobId> getJobIds() {
        try {
            return Files.list(this.basePath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).map(JobId::new).collect(Collectors.toSet());
        }
        catch (IOException ex) {
            LOG.error(COULD_NOT_LIST + this.basePath, (Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<JobId> getJobIds(OwsCode processId) {
        HashSet<JobId> jobIdsforProcess = new HashSet<JobId>();
        try {
            Set allJobIds = Files.list(this.basePath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).map(JobId::new).collect(Collectors.toSet());
            for (JobId jobId : allJobIds) {
                try {
                    JsonNode jsonMetadata = this.getJobMetadata(jobId);
                    String processIdFromMetadata = jsonMetadata.path("processId").textValue();
                    if (!processIdFromMetadata.equals(processId.getValue())) continue;
                    jobIdsforProcess.add(jobId);
                }
                catch (JobNotFoundException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        return jobIdsforProcess;
    }

    private static Optional<OffsetDateTime> getLastModifiedTime(Path directory) {
        try {
            return Optional.of(FileBasedResultPersistence.getLastModifiedTimeChecked(directory));
        }
        catch (IOException ex) {
            LOG.warn("Could not read last modified time of " + directory, (Throwable)ex);
            return Optional.empty();
        }
    }

    private static OffsetDateTime getLastModifiedTimeChecked(Path directory) throws IOException {
        return Files.getLastModifiedTime(directory, new LinkOption[0]).toInstant().atOffset(ZoneOffset.UTC);
    }

    private static interface Keys {
        public static final String PROCESS_ID = "processId";
        public static final String RESPONSE_MODE = "responseMode";
        public static final String ERROR = "error";
        public static final String STATUS = "status";
        public static final String FORMAT = "format";
        public static final String ENCODING = "encoding";
        public static final String HREF = "href";
        public static final String JOB_ID = "jobId";
        public static final String ID = "id";
        public static final String FILE = "file";
        public static final String EXPIRATION_DATE = "expirationDate";
        public static final String OUTPUTS = "outputs";
        public static final String CODE_SPACE = "codeSpace";
        public static final String TYPE = "type";
        public static final String DATA_TRANSMISSION_MODE = "dataTransmissionMode";
        public static final String VALUE = "value";
        public static final String BODY = "body";
        public static final String BODY_HREF = "bodyHref";
        public static final String MIME_TYPE = "mimeType";
        public static final String SCHEMA = "schema";
    }

    private static class CleanupTask
    extends TimerTask {
        private final Path basePath;
        private final Duration duration;

        CleanupTask(Path basePath, Duration duration) {
            this.basePath = basePath;
            this.duration = duration;
        }

        @Override
        public void run() {
            this.list(this.basePath).filter(this.shouldBeDeleted(OffsetDateTime.now().minus(this.duration))).forEach(this::delete);
        }

        private Predicate<Path> shouldBeDeleted(OffsetDateTime threshold) {
            return path -> Files.isDirectory(path, new LinkOption[0]) && FileBasedResultPersistence.getLastModifiedTime(path).filter(dt -> dt.compareTo(threshold) <= 0).isPresent();
        }

        private void delete(Path path) {
            try {
                MoreFiles.deleteRecursively((Path)path);
            }
            catch (IOException ex) {
                LOG.warn("Could not delete " + path, (Throwable)ex);
            }
        }

        private Stream<Path> list(Path path) {
            try {
                return Files.list(path);
            }
            catch (IOException ex) {
                LOG.warn(FileBasedResultPersistence.COULD_NOT_LIST + path, (Throwable)ex);
                return Stream.empty();
            }
        }
    }
}

