/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.engine.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.n52.javaps.algorithm.ProcessInputs;
import org.n52.javaps.description.TypedGroupInputDescription;
import org.n52.javaps.description.TypedProcessDescription;
import org.n52.javaps.description.TypedProcessInputDescription;
import org.n52.javaps.description.TypedProcessInputDescriptionContainer;
import org.n52.javaps.engine.InputDecodingException;
import org.n52.javaps.engine.ProcessInputDecoder;
import org.n52.javaps.engine.UnsupportedInputFormatException;
import org.n52.javaps.engine.impl.ResolvableReferenceProcessData;
import org.n52.javaps.io.Data;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.GroupInputData;
import org.n52.javaps.io.InputHandler;
import org.n52.javaps.io.InputHandlerRepository;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.data.GroupProcessData;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.data.ReferenceProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;

public class ProcessInputDecoderImpl
implements ProcessInputDecoder {
    private final InputHandlerRepository inputHandlerRepository;

    @Inject
    public ProcessInputDecoderImpl(InputHandlerRepository inputHandlerRepository) {
        this.inputHandlerRepository = inputHandlerRepository;
    }

    @Override
    public ProcessInputs decode(TypedProcessDescription description, List<ProcessData> processInputs) throws InputDecodingException {
        return this.decodeContainer(description, processInputs);
    }

    private Data<?> decode(TypedProcessInputDescription<?> description, ProcessData input) throws InputDecodingException {
        if (input.isGroup()) {
            return this.decodeGroup(description.asGroup(), input.asGroup());
        }
        if (input.isReference()) {
            return this.decodeReference(description, input.asReference());
        }
        if (input.isValue()) {
            return this.decodeValueInput(description, input.asValue());
        }
        throw new AssertionError((Object)("Unsupported input type: " + input));
    }

    private ProcessInputs decodeContainer(TypedProcessInputDescriptionContainer description, List<ProcessData> processInputs) throws InputDecodingException {
        HashMap<OwsCode, List> data = new HashMap<OwsCode, List>(processInputs.size());
        for (ProcessData input : processInputs) {
            Data<?> decodedInput = this.decode((TypedProcessInputDescription<?>)description.getInput(input.getId()), input);
            data.computeIfAbsent(input.getId(), id -> new LinkedList()).add(decodedInput);
        }
        return new ProcessInputs((Map<? extends OwsCode, ? extends List<Data<?>>>)data);
    }

    private Data<?> decodeGroup(TypedGroupInputDescription description, GroupProcessData input) throws InputDecodingException {
        return new GroupInputData(this.decodeContainer(description, input.getElements()));
    }

    private Data<?> decodeReference(TypedProcessInputDescription<?> description, ReferenceProcessData input) throws InputDecodingException {
        ValueProcessData resolve;
        try {
            resolve = new ResolvableReferenceProcessData(input).resolve();
        }
        catch (IOException ex) {
            throw new InputDecodingException(input.getId(), (Throwable)ex);
        }
        return this.decode(description, (ProcessData)resolve);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Data<?> decodeValueInput(TypedProcessInputDescription<?> description, ValueProcessData input) throws InputDecodingException {
        Format format = input.getFormat();
        Class bindingType = description.getBindingType();
        InputHandler handler = this.inputHandlerRepository.getInputHandler(format, bindingType).orElseThrow(ProcessInputDecoderImpl.noHandlerFound(input.getId()));
        try (InputStream data = input.getData();){
            Data<?> data2 = handler.parse(description, data, format);
            return data2;
        }
        catch (IOException | DecodingException ex) {
            throw new InputDecodingException(input.getId(), (Throwable)ex);
        }
    }

    private static Supplier<InputDecodingException> noHandlerFound(OwsCode id) {
        return () -> new InputDecodingException(id, (Throwable)new UnsupportedInputFormatException());
    }
}

