/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.n52.javaps.algorithm.ProcessOutputs;
import org.n52.javaps.description.TypedProcessOutputDescription;
import org.n52.javaps.description.TypedProcessOutputDescriptionContainer;
import org.n52.javaps.engine.EngineProcessExecutionContext;
import org.n52.javaps.engine.OutputEncodingException;
import org.n52.javaps.engine.ProcessOutputEncoder;
import org.n52.javaps.engine.UnsupportedOutputFormatException;
import org.n52.javaps.engine.impl.GeneratingProcessData;
import org.n52.javaps.io.Data;
import org.n52.javaps.io.GroupOutputData;
import org.n52.javaps.io.OutputHandler;
import org.n52.javaps.io.OutputHandlerRepository;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.OutputDefinition;
import org.n52.shetland.ogc.wps.data.GroupProcessData;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.description.ProcessOutputDescription;

public class ProcessOutputEncoderImpl
implements ProcessOutputEncoder {
    private final OutputHandlerRepository outputHandlerRepository;

    @Inject
    public ProcessOutputEncoderImpl(OutputHandlerRepository outputHandlerRepository) {
        this.outputHandlerRepository = outputHandlerRepository;
    }

    @Override
    public List<ProcessData> create(EngineProcessExecutionContext context) throws OutputEncodingException {
        ArrayList<ProcessData> list = new ArrayList<ProcessData>(context.getOutputs().size());
        this.createData(context.getDescription(), context.getOutputDefinitions(), context.getOutputs(), list::add);
        return list;
    }

    private void createData(TypedProcessOutputDescriptionContainer description, Map<OwsCode, OutputDefinition> outputDefinitions, ProcessOutputs outputs, Consumer<ProcessData> sink) throws OutputEncodingException {
        for (Map.Entry output : outputs.entrySet()) {
            OwsCode id = (OwsCode)output.getKey();
            ProcessOutputDescription outputDescription = description.getOutput(id);
            OutputDefinition outputDefinition = outputDefinitions.get(id);
            if (outputDefinition == null) continue;
            Data data = (Data)output.getValue();
            if (outputDescription.isGroup()) {
                sink.accept(this.createGroupData((TypedProcessOutputDescription<?>)outputDescription, outputDefinition, data));
                continue;
            }
            sink.accept(this.createValueData((TypedProcessOutputDescription<?>)outputDescription, outputDefinition, data));
        }
    }

    private ProcessData createValueData(TypedProcessOutputDescription<?> outputDescription, OutputDefinition outputDefinition, Data<?> data) throws OutputEncodingException {
        OutputHandler outputHandler = this.outputHandlerRepository.getOutputHandler(outputDefinition.getFormat(), data).orElseThrow(ProcessOutputEncoderImpl.noHandlerFound(outputDescription.getId()));
        return new GeneratingProcessData(outputDescription, outputDefinition, outputHandler, data);
    }

    private ProcessData createGroupData(TypedProcessOutputDescription<?> outputDescription, OutputDefinition outputDefinition, Data<?> data) throws OutputEncodingException {
        GroupProcessData groupProcessData = new GroupProcessData(outputDescription.getId());
        ProcessOutputs groupProcessOutputs = ((GroupOutputData)data).getPayload();
        this.createData(outputDescription.asGroup(), outputDefinition.getOutputsById(), groupProcessOutputs, arg_0 -> ((GroupProcessData)groupProcessData).addElement(arg_0));
        return groupProcessData;
    }

    private static Supplier<OutputEncodingException> noHandlerFound(OwsCode id) {
        return () -> new OutputEncodingException(id, (Throwable)new UnsupportedOutputFormatException());
    }
}

