/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.codec.binary.Base64InputStream;
import org.n52.iceland.util.XmlFactories;
import org.n52.javaps.description.TypedLiteralInputDescription;
import org.n52.javaps.description.TypedLiteralOutputDescription;
import org.n52.javaps.description.TypedProcessInputDescription;
import org.n52.javaps.description.TypedProcessOutputDescription;
import org.n52.javaps.io.Data;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.EncodingException;
import org.n52.javaps.io.InputHandler;
import org.n52.javaps.io.OutputHandler;
import org.n52.javaps.io.literal.LiteralData;
import org.n52.javaps.io.literal.LiteralType;
import org.n52.shetland.ogc.wps.Format;

public class LiteralInputOutputHandler
extends XmlFactories
implements InputHandler,
OutputHandler {
    public static final Set<Format> FORMATS = Collections.unmodifiableSet(new LinkedHashSet<Format>(Arrays.asList(Format.APPLICATION_XML, Format.TEXT_XML, Format.TEXT_PLAIN, Format.TEXT_PLAIN.withBase64Encoding())));
    private static final Set<Class<? extends Data<?>>> BINDINGS = Collections.singleton(LiteralData.class);
    private static final String NS_WPS = "wps";
    private static final String NS_WPS_URI = "http://www.opengis.net/wps/2.0";
    private static final String EN_LITERAL_VALUE = "LiteralValue";
    private static final String AN_UOM = "uom";
    private static final String AN_DATA_TYPE = "dataType";
    private static final QName QN_DATA_TYPE = new QName("dataType");
    private static final QName QN_UOM = new QName("uom");
    private static final QName QN_LITERAL_VALUE = new QName("http://www.opengis.net/wps/2.0", "LiteralValue");

    @Override
    public Set<Format> getSupportedFormats() {
        return Collections.unmodifiableSet(FORMATS);
    }

    @Override
    public Set<Class<? extends Data<?>>> getSupportedBindings() {
        return BINDINGS;
    }

    @Override
    public Data<?> parse(TypedProcessInputDescription<?> description, InputStream input, Format format) throws IOException, DecodingException {
        if (format.isXML()) {
            return this.parseXML(description.asLiteral(), input, format);
        }
        if (format.isBase64()) {
            return this.parsePlain(description.asLiteral(), (InputStream)new Base64InputStream(input, false), format.withoutEncoding());
        }
        return this.parsePlain(description.asLiteral(), input, format);
    }

    private LiteralData parsePlain(TypedLiteralInputDescription description, InputStream input, Format format) throws IOException, DecodingException {
        Charset charset = format.getEncodingAsCharsetOrDefault();
        try (InputStreamReader reader = new InputStreamReader(input, charset);){
            String string = CharStreams.toString((Readable)reader);
            LiteralData literalData = ((LiteralType)description.getType()).parseToBinding(string);
            return literalData;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LiteralData parseXML(TypedLiteralInputDescription description, InputStream input, Format format) throws IOException, DecodingException {
        Charset charset = format.getEncodingAsCharsetOrDefault();
        try (InputStreamReader reader = new InputStreamReader(input, charset);){
            LiteralData literalData = this.parseData(description, reader);
            return literalData;
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private LiteralData parseData(TypedLiteralInputDescription description, Reader reader) throws XMLStreamException, DecodingException {
        XMLEventReader xmlReader = this.inputFactory().createXMLEventReader(reader);
        while (xmlReader.hasNext()) {
            XMLEvent event = xmlReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement start = event.asStartElement();
            if (start.getName().equals(QN_LITERAL_VALUE)) {
                String uom = Optional.ofNullable(start.getAttributeByName(QN_UOM)).map(Attribute::getValue).orElse(null);
                return ((LiteralType)description.getType()).parseToBinding(xmlReader.getElementText(), uom);
            }
            throw this.unexpectedTag(start);
        }
        throw this.eof();
    }

    @Override
    public InputStream generate(TypedProcessOutputDescription<?> description, Data<?> data, Format format) throws IOException, EncodingException {
        LiteralData literalData = (LiteralData)data;
        TypedLiteralOutputDescription literalDescription = description.asLiteral();
        if (format.isXML()) {
            return this.generateXML(literalDescription, literalData, format);
        }
        if (format.isBase64()) {
            InputStream stream = this.generatePlain(literalDescription, literalData, format.withoutEncoding());
            return new Base64InputStream(stream, true);
        }
        return this.generatePlain(literalDescription, literalData, format);
    }

    private InputStream generatePlain(TypedLiteralOutputDescription description, LiteralData data, Format format) throws EncodingException {
        return LiteralInputOutputHandler.toStream(this.toString(description, data), format);
    }

    private InputStream generateXML(TypedLiteralOutputDescription description, LiteralData data, Format format) throws IOException, EncodingException {
        try {
            StringWriter writer = new StringWriter();
            this.writeData(description, writer, data);
            return LiteralInputOutputHandler.toStream(writer.toString(), format);
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private String toString(TypedLiteralOutputDescription description, LiteralData data) throws EncodingException {
        LiteralType type = (LiteralType)description.getType();
        String value = type.generate(data.getPayload());
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(TypedLiteralOutputDescription description, Writer writer, LiteralData data) throws XMLStreamException, EncodingException {
        try (XMLStreamWriter xmlWriter = this.outputFactory().createXMLStreamWriter(writer);){
            this.writeData(description, xmlWriter, data);
        }
    }

    private void writeData(TypedLiteralOutputDescription description, XMLStreamWriter writer, LiteralData data) throws XMLStreamException, EncodingException {
        writer.writeStartElement(NS_WPS, EN_LITERAL_VALUE, NS_WPS_URI);
        writer.writeNamespace(NS_WPS, NS_WPS_URI);
        writer.writeAttribute(AN_DATA_TYPE, ((LiteralType)description.getType()).getURI().toString());
        if (data.getUnitOfMeasurement().isPresent()) {
            writer.writeAttribute(AN_UOM, data.getUnitOfMeasurement().get());
        }
        writer.writeCharacters(this.toString(description, data));
        writer.writeEndElement();
    }

    private static InputStream toStream(String value, Format format) {
        Charset charset = format.getEncodingAsCharsetOrDefault();
        return new ByteArrayInputStream(value.getBytes(charset));
    }
}

