/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal.xsd;

import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.literal.xsd.AbstractXSDLiteralType;

public class LiteralTimeType
extends AbstractXSDLiteralType<LocalTime> {
    private static final long serialVersionUID = 7112303815634646266L;

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public LocalTime parse(String value) throws DecodingException {
        try {
            return LocalTime.from(DateTimeFormatter.ISO_TIME.parse(value));
        }
        catch (DateTimeException ex) {
            throw new DecodingException(ex);
        }
    }

    @Override
    public Class<LocalTime> getPayloadType() {
        return LocalTime.class;
    }

    @Override
    public String generate(LocalTime value) {
        return value.atOffset(ZoneOffset.UTC).toString();
    }
}

