/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.utils;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);
    private static final String FILE = "file";
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");

    private IOUtils() {
    }

    public static File writeBase64ToFile(InputStream input, String extension) throws IOException {
        return IOUtils.writeBase64(extension, input).toFile();
    }

    public static File writeStreamToFile(InputStream inputStream, String extension) throws IOException {
        File file = File.createTempFile(FILE + UUID.randomUUID(), "." + extension);
        return IOUtils.writeStreamToFile(inputStream, extension, file);
    }

    @Deprecated
    public static File writeStreamToFile(InputStream inputStream, String extension, File file) throws IOException {
        Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        return file;
    }

    public static File zip(File ... files) throws IOException {
        File zip = File.createTempFile("zip" + UUID.randomUUID(), ".zip");
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));){
            byte[] buffer = new byte[4096];
            for (File file : files) {
                if (!file.exists()) {
                    LOGGER.debug("Could not zip " + file.getAbsolutePath());
                    continue;
                }
                out.putNextEntry(new ZipEntry(file.getName()));
                try (FileInputStream in = new FileInputStream(file);){
                    int len;
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.closeEntry();
                }
            }
            IOUtils.deleteResources(files);
        }
        return zip;
    }

    public static List<File> unzip(File file, String extension) throws IOException {
        return IOUtils.unzip(file, extension, null);
    }

    public static List<File> unzip(File file, String extension, File directory) throws IOException {
        return IOUtils.unzipAll(file).stream().filter(f -> f.getName().endsWith("." + extension)).collect(Collectors.toList());
    }

    public static List<File> unzipAll(File file) throws IOException {
        byte[] buffer = new byte[2048];
        ArrayList<File> foundFiles = new ArrayList<File>();
        File tempDir = Files.createTempDirectory("unzipped", new FileAttribute[0]).toFile();
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                File entryFile = new File(tempDir, entry.getName());
                boolean created = entryFile.createNewFile();
                if (!created) {
                    LOGGER.info("File already exists: " + entryFile.getAbsolutePath());
                    continue;
                }
                try (BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(entryFile), buffer.length);){
                    int count;
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        dest.write(buffer, 0, count);
                    }
                    dest.flush();
                }
                foundFiles.add(entryFile);
            }
        }
        IOUtils.deleteResources(file);
        return foundFiles;
    }

    public static void deleteResources(File ... files) {
        for (File file : files) {
            if (file == null || !file.getAbsolutePath().startsWith(TMP_DIR)) continue;
            IOUtils.delete(file);
            File parent = file.getAbsoluteFile().getParentFile();
            if (parent == null || parent.getAbsolutePath().equals(TMP_DIR)) continue;
            parent.deleteOnExit();
        }
    }

    private static void delete(File ... files) {
        for (File file : files) {
            if (file == null) continue;
            String baseName = file.getName().substring(0, file.getName().lastIndexOf(46));
            File[] list = file.getAbsoluteFile().getParentFile().listFiles(pathname -> pathname.getName().startsWith(baseName));
            if (list != null) {
                for (File f : list) {
                    f.deleteOnExit();
                }
            }
            file.deleteOnExit();
        }
    }

    public static Path writeBase64(String extension, InputStream input) throws IOException {
        Path file = Files.createTempFile(FILE, ".".concat(extension), new FileAttribute[0]);
        try (Base64InputStream in = new Base64InputStream((InputStream)new BufferedInputStream(input), true);
             BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        return file;
    }
}

