/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.n52.javaps.algorithm.AlgorithmRepository;
import org.n52.javaps.algorithm.IAlgorithm;
import org.n52.javaps.algorithm.annotation.Algorithm;
import org.n52.javaps.algorithm.annotation.AnnotatedAlgorithm;
import org.n52.javaps.description.TypedProcessDescription;
import org.n52.javaps.io.InputHandlerRepository;
import org.n52.javaps.io.OutputHandlerRepository;
import org.n52.javaps.io.literal.LiteralTypeRepository;
import org.n52.shetland.ogc.ows.OwsCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class LocalAlgorithmRepository
implements AlgorithmRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAlgorithmRepository.class);
    private final Map<OwsCode, TypedProcessDescription> descriptions = new HashMap<OwsCode, TypedProcessDescription>();
    private final Map<OwsCode, Supplier<IAlgorithm>> algorithms = new HashMap<OwsCode, Supplier<IAlgorithm>>();
    private final InputHandlerRepository parserRepository;
    private final OutputHandlerRepository generatorRepository;
    private final LiteralTypeRepository literalTypeRepository;
    private final AutowireCapableBeanFactory beanFactory;
    private final String duplicateAlgorithmId = "Duplicate algorithm identifier: {}";

    @Inject
    public LocalAlgorithmRepository(InputHandlerRepository parserRepository, OutputHandlerRepository generatorRepository, LiteralTypeRepository literalTypeRepository, ApplicationContext applicationContext) {
        this.parserRepository = Objects.requireNonNull(parserRepository);
        this.generatorRepository = Objects.requireNonNull(generatorRepository);
        this.literalTypeRepository = Objects.requireNonNull(literalTypeRepository);
        this.beanFactory = applicationContext.getAutowireCapableBeanFactory();
    }

    @Override
    public Optional<IAlgorithm> getAlgorithm(OwsCode id) {
        return Optional.ofNullable(this.algorithms.get(id)).map(Supplier::get);
    }

    @Override
    public Optional<TypedProcessDescription> getProcessDescription(OwsCode id) {
        return Optional.ofNullable(this.descriptions.get(id));
    }

    @Override
    public Set<OwsCode> getAlgorithmNames() {
        return new HashSet<OwsCode>(this.algorithms.keySet());
    }

    @Override
    public boolean containsAlgorithm(OwsCode id) {
        return this.descriptions.containsKey(id);
    }

    public void addAlgorithm(String className) {
        Objects.requireNonNull(className, "className");
        try {
            this.addAlgorithm(this.getClass().getClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException ex) {
            LOG.error("Could not load algorithm class " + className, (Throwable)ex);
        }
    }

    public void addAlgorithm(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        this.instantiate(clazz).ifPresent(instance -> {
            TypedProcessDescription description = instance.getDescription();
            if (this.descriptions.put(description.getId(), description) != null) {
                LOG.warn("Duplicate algorithm identifier: {}", (Object)description.getId());
            }
            Supplier<Error> error = () -> new Error("Could not instantiate algorithm " + description.getId());
            this.algorithms.put(description.getId(), () -> this.instantiate(clazz).orElseThrow(error));
            LOG.info("Algorithm class {} with id {} registered", (Object)clazz, (Object)description.getId());
        });
    }

    public void addAlgorithm(IAlgorithm instance) {
        Objects.requireNonNull(instance, "instance");
        TypedProcessDescription description = instance.getDescription();
        if (this.descriptions.put(description.getId(), description) != null) {
            LOG.warn("Duplicate algorithm identifier: {}", (Object)description.getId());
        }
        this.algorithms.put(description.getId(), () -> instance);
        LOG.info("Algorithm {} with id {} registered", (Object)instance, (Object)description.getId());
    }

    public void addAlgorithm(Object object) {
        Objects.requireNonNull(object);
        if (object instanceof IAlgorithm) {
            this.addAlgorithm((IAlgorithm)object);
        } else if (object instanceof Class) {
            this.addAlgorithm((Class)object);
        } else if (object.getClass().isAnnotationPresent(Algorithm.class)) {
            this.addAlgorithm(new AnnotatedAlgorithm(this.parserRepository, this.generatorRepository, this.literalTypeRepository, object));
        } else {
            LOG.error("Could not add algorithm {}", object);
        }
    }

    public boolean removeAlgorithm(String identifier) {
        OwsCode owsCode = new OwsCode(identifier);
        return this.removeAlgorithm(owsCode);
    }

    public boolean removeAlgorithm(OwsCode identifier) {
        Supplier<IAlgorithm> removedAlgorithm = this.algorithms.remove(identifier);
        return removedAlgorithm != null;
    }

    private Optional<IAlgorithm> instantiate(Class<?> clazz) {
        Object instance;
        try {
            instance = this.beanFactory.createBean(clazz);
        }
        catch (BeansException ex) {
            LOG.warn("Could not instantiate algorithm", (Throwable)ex);
            return Optional.empty();
        }
        if (clazz.isAnnotationPresent(Algorithm.class) && !(instance instanceof AnnotatedAlgorithm)) {
            return Optional.of(new AnnotatedAlgorithm(this.parserRepository, this.generatorRepository, this.literalTypeRepository, instance));
        }
        if (instance instanceof IAlgorithm) {
            return Optional.of((IAlgorithm)instance);
        }
        LOG.warn("Algorithm class is not annotated and does not implement IAlgorithm: {}", clazz);
        return Optional.empty();
    }
}

