/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.engine.impl;

import com.google.common.io.ByteStreams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.data.Body;
import org.n52.shetland.ogc.wps.data.ReferenceProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;
import org.n52.shetland.ogc.wps.data.impl.InMemoryValueProcessData;
import org.n52.shetland.util.HTTP;

public class ResolvableReferenceProcessData
extends ReferenceProcessData {
    public ResolvableReferenceProcessData(OwsCode id) {
        this(id, null, null, null);
    }

    public ResolvableReferenceProcessData(OwsCode id, URI uri) {
        this(id, null, uri, null);
    }

    public ResolvableReferenceProcessData(OwsCode id, Format format, URI uri) {
        this(id, format, uri, null);
    }

    public ResolvableReferenceProcessData(OwsCode id, Format format, URI uri, Body body) {
        super(id, format, uri, body);
    }

    public ResolvableReferenceProcessData() {
        this(null, null, null, null);
    }

    public ResolvableReferenceProcessData(ReferenceProcessData data) {
        this(data.getId(), data.getFormat(), data.getURI(), data.getBody().orElse(null));
    }

    public ValueProcessData resolve() throws IOException {
        byte[] bytes;
        if (!this.getBody().isPresent()) {
            switch (this.getURI().getScheme()) {
                case "file": {
                    bytes = this.getFromLocalDisc();
                    break;
                }
                default: {
                    bytes = HTTP.get((URI)this.getURI());
                    break;
                }
            }
        } else {
            bytes = HTTP.post((URI)this.getURI(), (byte[])((Body)this.getBody().get()).getBody().getBytes(StandardCharsets.UTF_8));
        }
        return new InMemoryValueProcessData(this.getId(), this.getFormat(), bytes);
    }

    private byte[] getFromLocalDisc() throws IOException {
        URL fileURL = this.getURI().toURL();
        try (FileInputStream is = new FileInputStream(fileURL.getFile());){
            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
            return byArray;
        }
    }
}

