/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.engine.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.n52.janmayen.Chain;
import org.n52.javaps.engine.OutputReference;
import org.n52.javaps.engine.OutputReferencer;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.JobId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class StaticURLOutputReferencer
implements OutputReferencer {
    private final Logger LOG = LoggerFactory.getLogger(StaticURLOutputReferencer.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private URI baseURI;

    @Override
    public URI reference(OutputReference identifier) {
        UriComponentsBuilder builder;
        this.lock.readLock().lock();
        try {
            builder = UriComponentsBuilder.fromUri((URI)this.baseURI);
        }
        finally {
            this.lock.readLock().unlock();
        }
        builder.pathSegment(new String[]{identifier.getJobId().getValue()});
        identifier.getOutputId().stream().map(OwsCode::getValue).forEach(xva$0 -> builder.pathSegment(new String[]{xva$0}));
        return builder.build().toUri();
    }

    @Override
    public OutputReference dereference(URI uri) throws IllegalArgumentException {
        UriComponents build;
        this.lock.readLock().lock();
        try {
            URI relative = this.baseURI.relativize(new URL(this.baseURI.toURL(), uri.toString()).toURI());
            build = UriComponentsBuilder.fromUri((URI)relative).build();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        finally {
            this.lock.readLock().unlock();
        }
        Iterator<String> iterator = build.getPathSegments().iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        JobId jobId = new JobId((String)iterator.next());
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        LinkedList chain = new LinkedList();
        iterator.forEachRemaining(x -> chain.add(new OwsCode(x)));
        return new OutputReference(jobId, (Chain<OwsCode>)new Chain(chain));
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI baseURI) {
        this.lock.writeLock().lock();
        try {
            this.baseURI = Objects.requireNonNull(baseURI);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

