/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.n52.javaps.annotation.ConfigurableClass;
import org.n52.javaps.io.AbstractInputOutputHandler;
import org.n52.shetland.ogc.wps.Format;

public class AbstractPropertiesInputOutputHandler
extends AbstractInputOutputHandler
implements ConfigurableClass {
    private final Set<Format> supportedFormats = this.getFormatsFromProperties();

    @Override
    public Set<Format> getSupportedFormats() {
        return Collections.unmodifiableSet(this.supportedFormats);
    }

    public void addSupportedFormat(Format supportedFormat) {
        this.supportedFormats.add(Objects.requireNonNull(supportedFormat));
    }

    public void addSupportedFormats(Iterable<Format> supportedFormats) {
        supportedFormats.forEach(this::addSupportedFormat);
    }

    private Set<Format> getFormatsFromProperties() {
        JsonNode node = this.getProperties().path("formats");
        return StreamSupport.stream(node.spliterator(), false).map(this::parseFormat).filter(x -> !x.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Format parseFormat(JsonNode node) {
        String mimeType = node.path("mimeType").textValue();
        String schema = node.path("schema").textValue();
        String encoding = node.path("encoding").textValue();
        return new Format(mimeType, encoding, schema);
    }
}

