/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm;

import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.javaps.algorithm.IAlgorithm;
import org.n52.javaps.algorithm.LocalAlgorithmRepository;
import org.n52.javaps.algorithm.annotation.Algorithm;
import org.n52.javaps.utils.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAlgorithmRegistrator
implements Constructable {
    private static final Logger LOG = LoggerFactory.getLogger(ContextAlgorithmRegistrator.class);
    private LocalAlgorithmRepository repository;
    private Context context;

    public void init() {
        Stream.concat(this.interfaceImplementations(), this.annotatedInstances()).peek(algorithm -> LOG.info("Registering {}", algorithm)).forEach(this.repository::addAlgorithm);
    }

    @Inject
    public void setContext(Context context) {
        this.context = context;
    }

    @Inject
    public void setRepository(LocalAlgorithmRepository repository) {
        this.repository = Objects.requireNonNull(repository);
    }

    private Stream<IAlgorithm> interfaceImplementations() {
        return this.context.getInstances(IAlgorithm.class).stream();
    }

    private Stream<Object> annotatedInstances() {
        return this.context.getAnnotatedInstances(Algorithm.class).stream();
    }
}

