/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import com.google.common.primitives.Primitives;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.Objects;
import org.n52.javaps.algorithm.annotation.AnnotationBinding;
import org.n52.javaps.description.TypedDataDescription;

abstract class AbstractDataBinding<M extends AccessibleObject, D extends TypedDataDescription<?>>
extends AnnotationBinding<M> {
    private D description;

    AbstractDataBinding(M member) {
        super(member);
    }

    public abstract Type getMemberType();

    public Type getType() {
        return this.getMemberType();
    }

    public Type getPayloadType() {
        Type type = this.getType();
        if (AbstractDataBinding.isEnum(type)) {
            return String.class;
        }
        if (type instanceof Class) {
            return Primitives.wrap((Class)((Class)type));
        }
        return type;
    }

    protected Object outputToPayload(Object outputValue) {
        Type type = this.getType();
        if (AbstractDataBinding.isEnum(type)) {
            return ((Enum)outputValue).name();
        }
        return outputValue;
    }

    protected Object payloadToInput(Object payload) {
        Type type = this.getType();
        if (AbstractDataBinding.isEnum(type)) {
            Class enumClass = (Class)type;
            return Enum.valueOf(enumClass, (String)payload);
        }
        return payload;
    }

    public boolean isEnum() {
        return AbstractDataBinding.isEnum(this.getType());
    }

    public static boolean isEnum(Type type) {
        return type instanceof Class && ((Class)type).isEnum();
    }

    public void setDescription(D description) {
        this.description = (TypedDataDescription)Objects.requireNonNull(description);
    }

    public D getDescription() {
        return this.description;
    }
}

