/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.bbox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.codec.binary.Base64InputStream;
import org.n52.iceland.util.XmlFactories;
import org.n52.javaps.description.TypedProcessInputDescription;
import org.n52.javaps.description.TypedProcessOutputDescription;
import org.n52.javaps.io.Data;
import org.n52.javaps.io.InputHandler;
import org.n52.javaps.io.OutputHandler;
import org.n52.javaps.io.bbox.BoundingBoxData;
import org.n52.shetland.ogc.ows.OwsBoundingBox;
import org.n52.shetland.ogc.wps.Format;

public class BoundingBoxInputOutputHandler
extends XmlFactories
implements InputHandler,
OutputHandler {
    public static final Set<Format> FORMATS = Collections.unmodifiableSet(new LinkedHashSet<Format>(Arrays.asList(Format.APPLICATION_XML, Format.TEXT_XML)));
    private static final Set<Class<? extends Data<?>>> BINDINGS = Collections.singleton(BoundingBoxData.class);
    private static final String NS_URI = "http://www.opengis.net/ows/2.0";
    private static final String NS_PREFIX = "ows";
    private static final String EN_UPPER_CORNER = "UpperCorner";
    private static final String EN_LOWER_CORNER = "LowerCorner";
    private static final String EN_BOUNDING_BOX = "BoundingBox";
    private static final String AN_DIMENSION = "dimension";
    private static final String AN_CRS = "crs";
    private static final QName QN_BOUNDING_BOX = new QName("http://www.opengis.net/ows/2.0", "BoundingBox");
    private static final QName QN_CRS = new QName("crs");
    private static final QName QN_DIMENSION = new QName("dimension");
    private static final QName QN_LOWER_CORNER = new QName("http://www.opengis.net/ows/2.0", "LowerCorner");
    private static final QName QN_UPPER_CORNER = new QName("http://www.opengis.net/ows/2.0", "UpperCorner");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Data<?> parse(TypedProcessInputDescription<?> description, InputStream input, Format format) throws IOException {
        Charset charset = format.getEncodingAsCharsetOrDefault();
        try (InputStreamReader reader = new InputStreamReader(input, charset);){
            Data<?> data = this.parseBoundingBoxData(reader);
            return data;
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public Set<Format> getSupportedFormats() {
        return Collections.unmodifiableSet(FORMATS);
    }

    @Override
    public Set<Class<? extends Data<?>>> getSupportedBindings() {
        return BINDINGS;
    }

    private Data<?> parseBoundingBoxData(Reader reader) throws XMLStreamException {
        OwsBoundingBox bbox = null;
        XMLEventReader xmlReader = this.inputFactory().createXMLEventReader(reader);
        while (xmlReader.hasNext()) {
            XMLEvent event = xmlReader.nextEvent();
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                if (start.getName().equals(QN_BOUNDING_BOX)) {
                    bbox = this.parseBoundingBox(start, xmlReader);
                    continue;
                }
                throw this.unexpectedTag(start);
            }
            if (!event.isEndElement()) continue;
            return new BoundingBoxData(bbox);
        }
        throw this.eof();
    }

    private OwsBoundingBox parseBoundingBox(StartElement elem, XMLEventReader xmlReader) throws XMLStreamException {
        URI crs = Optional.ofNullable(elem.getAttributeByName(QN_CRS)).map(Attribute::getValue).map(URI::create).orElse(null);
        Integer dimension = Optional.ofNullable(elem.getAttributeByName(QN_DIMENSION)).map(Attribute::getValue).filter(s -> !s.isEmpty()).map(Integer::valueOf).filter(x -> x > 0).orElse(null);
        double[] lowerCorner = null;
        double[] upperCorner = null;
        while (xmlReader.hasNext()) {
            XMLEvent event = xmlReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement start = event.asStartElement();
            QName name = start.getName();
            if (name.equals(QN_LOWER_CORNER)) {
                lowerCorner = Arrays.stream(xmlReader.getElementText().split(" ")).mapToDouble(Double::parseDouble).toArray();
            } else if (name.equals(QN_UPPER_CORNER)) {
                upperCorner = Arrays.stream(xmlReader.getElementText().split(" ")).mapToDouble(Double::parseDouble).toArray();
            } else {
                throw this.unexpectedTag(start);
            }
            if (upperCorner == null || lowerCorner == null) continue;
            if (dimension == null) {
                return new OwsBoundingBox(lowerCorner, upperCorner, crs);
            }
            return new OwsBoundingBox(lowerCorner, upperCorner, dimension.intValue(), crs);
        }
        throw this.eof();
    }

    @Override
    public InputStream generate(TypedProcessOutputDescription<?> description, Data<?> data, Format format) throws IOException {
        try {
            Charset charset = format.getEncodingAsCharsetOrDefault();
            byte[] bytes = this.encode(data).getBytes(charset);
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            if (format.isBase64()) {
                return new Base64InputStream((InputStream)stream, true);
            }
            return stream;
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private String encode(Data<?> data) throws XMLStreamException {
        OwsBoundingBox bbox = (OwsBoundingBox)data.getPayload();
        StringWriter writer = new StringWriter();
        this.writeBoundingBox(writer, bbox);
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBoundingBox(Writer writer, OwsBoundingBox bbox) throws XMLStreamException {
        try (XMLStreamWriter xmlWriter = this.outputFactory().createXMLStreamWriter(writer);){
            this.writeBoundingBox(xmlWriter, bbox);
        }
    }

    private void writeBoundingBox(XMLStreamWriter writer, OwsBoundingBox bbox) throws XMLStreamException {
        writer.writeStartElement(NS_PREFIX, EN_BOUNDING_BOX, NS_URI);
        writer.writeNamespace(NS_PREFIX, NS_URI);
        if (bbox.getCRS().isPresent()) {
            writer.writeAttribute(AN_CRS, ((URI)bbox.getCRS().get()).toString());
        }
        writer.writeAttribute(AN_DIMENSION, String.valueOf(bbox.getDimension()));
        this.writeLowerCorner(writer, bbox.getLowerCorner());
        this.writeUpperCorner(writer, bbox.getUpperCorner());
        writer.writeEndElement();
    }

    private void writeLowerCorner(XMLStreamWriter writer, double[] lowerCorner) throws XMLStreamException {
        writer.writeStartElement(NS_PREFIX, EN_LOWER_CORNER, NS_URI);
        this.writerPositionType(writer, lowerCorner);
        writer.writeEndElement();
    }

    private void writeUpperCorner(XMLStreamWriter writer, double[] upperCorner) throws XMLStreamException {
        writer.writeStartElement(NS_PREFIX, EN_UPPER_CORNER, NS_URI);
        this.writerPositionType(writer, upperCorner);
        writer.writeEndElement();
    }

    private void writerPositionType(XMLStreamWriter writer, double[] coordinates) throws XMLStreamException {
        writer.writeCharacters(Arrays.stream(coordinates).mapToObj(String::valueOf).collect(Collectors.joining(" ")));
    }
}

