/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal.xsd;

import java.math.BigInteger;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.literal.xsd.AbstractXSDLiteralType;

public abstract class AbstractLiteralIntegerType<T>
extends AbstractXSDLiteralType<T> {
    private static final long serialVersionUID = -315068838227868527L;

    protected BigInteger asBigInteger(String value) throws DecodingException {
        try {
            BigInteger bigInteger = new BigInteger(value);
            if (!this.isInRange(bigInteger)) {
                throw new DecodingException("integer out of value range");
            }
            return bigInteger;
        }
        catch (IllegalArgumentException ex) {
            throw new DecodingException(ex);
        }
    }

    protected boolean isInRange(BigInteger value) {
        BigInteger max = this.min();
        BigInteger min = this.max();
        return !(min != null && min.compareTo(value) < 0 || max != null && max.compareTo(value) > 0);
    }

    protected abstract BigInteger min();

    protected abstract BigInteger max();
}

