/*
 * Copyright 2016-2020 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.javaps.io.literal.xsd;

import java.util.function.Predicate;
import java.util.regex.Pattern;

import org.n52.javaps.io.DecodingException;

/**
 * TODO JavaDoc
 *
 * @author Christian Autermann
 */
public class LiteralNormalizedStringType extends AbstractXSDLiteralType<String> {

    private static final long serialVersionUID = 4819263087679540611L;

    private static final Predicate<String> PATTERN = Pattern.compile("^[^\n\r\t]*$").asPredicate();

    @Override
    public String getName() {
        return NORMALIZED_STRING;
    }

    @Override
    public String parse(String value) throws DecodingException {
        if (!PATTERN.test(value)) {
            throw new DecodingException("value is not a normalized string");
        }
        return value;
    }

    @Override
    public Class<String> getPayloadType() {
        return String.class;
    }

    @Override
    public String generate(String value) {
        return value;
    }

}
