/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.annotation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.n52.janmayen.Json;
import org.n52.javaps.annotation.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableClasses {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableClasses.class);
    private static final Map<Class<?>, Optional<JsonNode>> CONFIGURATIONS = new ConcurrentHashMap();
    private static final String COULD_NOT_READ_PROPERTY = "Could not read property file for class ";

    public static Optional<JsonNode> get(Class<?> clazz) {
        return CONFIGURATIONS.computeIfAbsent(clazz, ConfigurableClasses::load);
    }

    private static Optional<JsonNode> load(Class<?> clazz) {
        Properties annotation = clazz.getAnnotation(Properties.class);
        if (annotation == null) {
            LOGGER.warn("Class extends {}, but is not annotated with {} annotation.", (Object)clazz.getName(), (Object)Properties.class.getName());
        } else {
            Optional<String> fileName = ConfigurableClasses.getPropertiesFileName(annotation);
            Optional<String> defaultFileName = ConfigurableClasses.getDefaultPropertiesFileName(annotation);
            if (!fileName.isPresent() && !defaultFileName.isPresent()) {
                LOGGER.warn("Class {} is annotated with {} annotation, but the annotation is empty.", (Object)clazz.getName(), (Object)Properties.class.getName());
            }
            URL fileURL = null;
            if (fileName.isPresent() && (fileURL = ConfigurableClasses.locateFile(fileName.get())) != null) {
                try {
                    return Optional.of(Json.loadURL((URL)fileURL));
                }
                catch (IOException e) {
                    LOGGER.error(COULD_NOT_READ_PROPERTY + clazz.getName(), (Throwable)e);
                }
            }
            if (defaultFileName.isPresent()) {
                fileURL = ConfigurableClasses.locateFile(defaultFileName.get());
                try {
                    return Optional.of(Json.loadURL((URL)fileURL));
                }
                catch (IOException e) {
                    LOGGER.error(COULD_NOT_READ_PROPERTY + clazz.getName(), (Throwable)e);
                }
            }
        }
        return Optional.empty();
    }

    private static URL locateFile(String fileName) {
        CombinedLocationStrategy strategy = new CombinedLocationStrategy(Arrays.asList(new FileSystemLocationStrategy(), new ClasspathLocationStrategy()));
        DefaultFileSystem fileSystem = new DefaultFileSystem();
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy((FileLocationStrategy)strategy).fileName(fileName).create();
        return strategy.locate((FileSystem)fileSystem, locator);
    }

    private static Optional<String> getPropertiesFileName(Properties annotation) {
        return Optional.ofNullable(annotation.propertyFileName()).map(Strings::emptyToNull);
    }

    private static Optional<String> getDefaultPropertiesFileName(Properties annotation) {
        return Optional.ofNullable(annotation.defaultPropertyFileName()).map(Strings::emptyToNull);
    }
}

