/*
 * Copyright 2016-2021 52°North Spatial Information Research GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.javaps.io;

import java.util.Optional;
import java.util.Set;

import org.n52.shetland.ogc.wps.Format;

/**
 * TODO JavaDoc
 *
 * @author Christian Autermann
 */
public interface OutputHandlerRepository extends FormatRepository {
    Set<OutputHandler> getOutputHandlers();

    Optional<OutputHandler> getOutputHandler(Format format,
            Class<? extends Data<?>> binding);

    @SuppressWarnings("unchecked")
    default Optional<OutputHandler> getOutputHandler(Format format,
            Data<?> binding) {
        return getOutputHandler(format, (Class<? extends Data<?>>) binding.getClass());
    }

}
