/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.n52.javaps.algorithm.annotation.AbstractInputAnnotationParser;
import org.n52.javaps.algorithm.annotation.AbstractInputBinding;
import org.n52.javaps.algorithm.annotation.ComplexInput;
import org.n52.javaps.description.TypedComplexInputDescription;
import org.n52.javaps.description.impl.TypedComplexInputDescriptionImpl;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.javaps.io.InputHandlerRepository;
import org.n52.javaps.io.complex.ComplexData;
import org.n52.shetland.ogc.wps.Format;

class ComplexInputAnnotationParser<M extends AccessibleObject, B extends AbstractInputBinding<M>>
extends AbstractInputAnnotationParser<ComplexInput, M, B> {
    private final InputHandlerRepository parserRepository;

    ComplexInputAnnotationParser(Function<M, B> bindingFunction, InputHandlerRepository parserRepository) {
        super(bindingFunction);
        this.parserRepository = Objects.requireNonNull(parserRepository);
    }

    @Override
    protected TypedComplexInputDescription createDescription(ComplexInput annotation, B binding) {
        Class<? extends ComplexData> bindingClass = annotation.binding();
        Set<Format> supportedFormats = this.parserRepository.getSupportedFormats(bindingClass);
        Format defaultFormat = this.parserRepository.getDefaultFormat(bindingClass).orElse(null);
        return ((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)((TypedComplexInputDescriptionImpl.Builder)new TypedProcessDescriptionFactory().complexInput().withIdentifier(annotation.identifier())).withAbstract(annotation.abstrakt())).withTitle(annotation.title())).withMinimalOccurence(annotation.minOccurs())).withMaximalOccurence(annotation.maxOccurs())).withMaximumMegabytes(annotation.maximumMegaBytes())).withDefaultFormat(defaultFormat)).withSupportedFormat(supportedFormats)).withType(bindingClass)).build();
    }

    @Override
    public Class<? extends ComplexInput> getSupportedAnnotation() {
        return ComplexInput.class;
    }
}

