/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.n52.javaps.io.literal.LiteralType;
import org.n52.javaps.io.literal.LiteralTypeRepository;
import org.n52.javaps.io.literal.xsd.Day;
import org.n52.javaps.io.literal.xsd.LiteralAnyURIType;
import org.n52.javaps.io.literal.xsd.LiteralBase64BinaryType;
import org.n52.javaps.io.literal.xsd.LiteralBooleanType;
import org.n52.javaps.io.literal.xsd.LiteralByteType;
import org.n52.javaps.io.literal.xsd.LiteralDateTimeType;
import org.n52.javaps.io.literal.xsd.LiteralDateType;
import org.n52.javaps.io.literal.xsd.LiteralDayType;
import org.n52.javaps.io.literal.xsd.LiteralDecimalType;
import org.n52.javaps.io.literal.xsd.LiteralDoubleType;
import org.n52.javaps.io.literal.xsd.LiteralDurationType;
import org.n52.javaps.io.literal.xsd.LiteralFloatType;
import org.n52.javaps.io.literal.xsd.LiteralIntType;
import org.n52.javaps.io.literal.xsd.LiteralIntegerType;
import org.n52.javaps.io.literal.xsd.LiteralLanguageType;
import org.n52.javaps.io.literal.xsd.LiteralLongType;
import org.n52.javaps.io.literal.xsd.LiteralMonthDayType;
import org.n52.javaps.io.literal.xsd.LiteralMonthType;
import org.n52.javaps.io.literal.xsd.LiteralShortType;
import org.n52.javaps.io.literal.xsd.LiteralStringType;
import org.n52.javaps.io.literal.xsd.LiteralTimeType;
import org.n52.javaps.io.literal.xsd.LiteralYearMonthType;
import org.n52.javaps.io.literal.xsd.LiteralYearType;
import org.n52.javaps.utils.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralTypeRepositoryImpl
implements LiteralTypeRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LiteralTypeRepositoryImpl.class);
    private final Context context;
    private final Map<Class<?>, Class<? extends LiteralType<?>>> mappings = new HashMap();

    @Inject
    public LiteralTypeRepositoryImpl(Context context) {
        this.context = context;
        this.registerMapping(BigDecimal.class, LiteralDecimalType.class);
        this.registerMapping(BigInteger.class, LiteralIntegerType.class);
        this.registerMapping(Boolean.class, LiteralBooleanType.class);
        this.registerMapping(Byte.class, LiteralByteType.class);
        this.registerMapping(byte[].class, LiteralBase64BinaryType.class);
        this.registerMapping(Day.class, LiteralDayType.class);
        this.registerMapping(Double.class, LiteralDoubleType.class);
        this.registerMapping(Duration.class, LiteralDurationType.class);
        this.registerMapping(Float.TYPE, LiteralFloatType.class);
        this.registerMapping(Integer.class, LiteralIntType.class);
        this.registerMapping(LocalDate.class, LiteralDateType.class);
        this.registerMapping(LocalDateTime.class, LiteralDateTimeType.class);
        this.registerMapping(Locale.class, LiteralLanguageType.class);
        this.registerMapping(LocalTime.class, LiteralTimeType.class);
        this.registerMapping(Long.class, LiteralLongType.class);
        this.registerMapping(Month.class, LiteralMonthType.class);
        this.registerMapping(MonthDay.class, LiteralMonthDayType.class);
        this.registerMapping(Short.class, LiteralShortType.class);
        this.registerMapping(String.class, LiteralStringType.class);
        this.registerMapping(URI.class, LiteralAnyURIType.class);
        this.registerMapping(Year.class, LiteralYearType.class);
        this.registerMapping(YearMonth.class, LiteralYearMonthType.class);
    }

    public final <T> void registerMapping(Class<T> bindingPayloadType, Class<? extends LiteralType<T>> literalType) {
        this.mappings.put(bindingPayloadType, literalType);
    }

    @Override
    public <T> LiteralType<T> getLiteralType(Class<? extends LiteralType<?>> literalType, Class<?> payloadType) {
        Optional<Object> type = literalType != null && !literalType.equals(LiteralType.class) ? this.getLiteralTypeForLiteralType(literalType) : (payloadType != null ? this.getLiteralTypeForPayloadType(payloadType) : Optional.empty());
        if (!type.isPresent()) {
            LOG.error("Could not find literal type for literalType {} and payloadType {}", literalType, payloadType);
        }
        return type.orElse(null);
    }

    @Override
    public Optional<LiteralType<?>> getLiteralType(String name) {
        return this.context.getInstances(LiteralType.class).stream().filter(i -> i.getName().equals(name)).findFirst().map(t -> t);
    }

    @Override
    public Optional<LiteralType<?>> getLiteralType(URI name) {
        return this.context.getInstances(LiteralType.class).stream().filter(i -> i.getURI().equals(name)).findFirst().map(t -> t);
    }

    private Optional<LiteralType> getLiteralTypeForPayloadType(Class<?> payloadType) {
        if (this.mappings.containsKey(payloadType)) {
            Class<? extends LiteralType<?>> typeClass = this.mappings.get(payloadType);
            return this.context.getInstance(typeClass);
        }
        return this.context.getInstances(LiteralType.class).stream().filter(i -> i.getPayloadType().equals(payloadType)).findFirst();
    }

    private Optional<LiteralType> getLiteralTypeForLiteralType(Class<?> literalType) {
        return this.context.getInstance(literalType);
    }
}

