/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import org.n52.javaps.algorithm.annotation.AbstractOutputAnnotationParser;
import org.n52.javaps.algorithm.annotation.AbstractOutputBinding;
import org.n52.javaps.algorithm.annotation.BoundingBoxOutput;
import org.n52.javaps.description.TypedBoundingBoxOutputDescription;
import org.n52.javaps.description.impl.TypedBoundingBoxOutputDescriptionImpl;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.shetland.ogc.ows.OwsCRS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoundingBoxOutputAnnotationParser<M extends AccessibleObject, B extends AbstractOutputBinding<M>>
extends AbstractOutputAnnotationParser<BoundingBoxOutput, M, B> {
    private static final Logger LOG = LoggerFactory.getLogger(BoundingBoxOutputAnnotationParser.class);

    BoundingBoxOutputAnnotationParser(Function<M, B> bindingFunction) {
        super(bindingFunction);
    }

    @Override
    public Class<? extends BoundingBoxOutput> getSupportedAnnotation() {
        return BoundingBoxOutput.class;
    }

    @Override
    public TypedBoundingBoxOutputDescription createDescription(BoundingBoxOutput annotation, B binding) {
        URI defaultCRSURI = null;
        try {
            defaultCRSURI = new URI(annotation.defaultCRSString());
        }
        catch (URISyntaxException e) {
            LOG.error("Could not create URI from String: " + annotation.defaultCRSString());
            defaultCRSURI = URI.create("http://www.opengis.net/def/crs/EPSG/0/4326");
        }
        TypedProcessDescriptionFactory descriptionFactory = new TypedProcessDescriptionFactory();
        return ((TypedBoundingBoxOutputDescriptionImpl.Builder)((TypedBoundingBoxOutputDescriptionImpl.Builder)((TypedBoundingBoxOutputDescriptionImpl.Builder)((TypedBoundingBoxOutputDescriptionImpl.Builder)descriptionFactory.boundingBoxOutput().withTitle(annotation.title())).withAbstract(annotation.abstrakt())).withIdentifier(annotation.identifier())).withDefaultCRS(new OwsCRS(defaultCRSURI))).build();
    }
}

